# Macros of LS-Reader's CMake

macro(link Language)
    string(COMPARE EQUAL ${Language} "CXX" CXX)
	string(COMPARE EQUAL ${Language} "C" C)
	if(CXX)
	    if(WIN32)
            if(MSVC_VERSION EQUAL 1600)
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/vs2010)
                link_directories(${LIB_DATA})
            elseif(MSVC_VERSION EQUAL 1900)
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/vs2015)
                link_directories(${LIB_DATA})
            elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/vs2017)
                link_directories(${LIB_DATA})
	        elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
		        set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/vs2019)
				link_directories(${LIB_DATA})
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
		        set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/vs2022)
		        link_directories(${LIB_DATA})
            endif(MSVC_VERSION EQUAL 1600)
        else(WIN32)
            set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercxxdist/lib/linux)
            link_directories(${LIB_DATA})
        endif(WIN32)
	elseif(C)
	    if(WIN32)
            if(MSVC_VERSION EQUAL 1600)
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/vs2010)
                link_directories(${LIB_DATA})
            elseif(MSVC_VERSION EQUAL 1900)
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/vs2015)
                link_directories(${LIB_DATA})
            elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
                set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/vs2017)
                link_directories(${LIB_DATA})
	        elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
		        set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/vs2019)
		        link_directories(${LIB_DATA})
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
		        set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/vs2022)
		        link_directories(${LIB_DATA})
            endif(MSVC_VERSION EQUAL 1600)
        else(WIN32)
            set(LIB_DATA ${PROJECT_SOURCE_DIR}/lsreadercdist/lib/linux)
            link_directories(${LIB_DATA})
        endif(WIN32)
	else()
	    message(STATUS "Please input correct language name")
	endif()
endmacro(link)

macro(target_link ProjectName Language)
    string(COMPARE EQUAL ${Language} "CXX" CXX)
	string(COMPARE EQUAL ${Language} "C" C)
	if(C)
		if(WIN32)
			if(MSVC_VERSION EQUAL 1600)
				target_link_libraries(${ProjectName} lsreader_c-vc100-0_1)
			elseif(MSVC_VERSION EQUAL 1900)
				target_link_libraries(${ProjectName} lsreader_c-vc140-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
				target_link_libraries(${ProjectName} lsreader_c-vc141-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
				target_link_libraries(${ProjectName} lsreader_c-vc142-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
				target_link_libraries(${ProjectName} lsreader_c-vc143-0_1)
			endif()
		else(WIN32)
			target_link_libraries(${ProjectName} lsreader_c)
		endif(WIN32)
	elseif(CXX)
		if(WIN32)
			if(MSVC_VERSION EQUAL 1600)
				target_link_libraries(${ProjectName} lsreader_cxx-vc100-0_1)
			elseif(MSVC_VERSION EQUAL 1900)
				target_link_libraries(${ProjectName} lsreader_cxx-vc140-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
				target_link_libraries(${ProjectName} lsreader_cxx-vc141-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
				target_link_libraries(${ProjectName} lsreader_cxx-vc142-0_1)
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
				target_link_libraries(${ProjectName} lsreader_cxx-vc143-0_1)
			endif()
		else()
			target_link_libraries(${ProjectName} lsreader_cxx)
		endif()
	else()
	    message(STATUS "Please input correct language name")
	endif()
endmacro(target_link)

macro(post_build ProjectName Language)
	string(COMPARE EQUAL ${Language} "CXX" CXX)
	string(COMPARE EQUAL ${Language} "C" C)
	if(CXX)
		if(WIN32)
			if(MSVC_VERSION EQUAL 1600)
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_cxx-vc100-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif(MSVC_VERSION EQUAL 1900)
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_cxx-vc140-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_cxx-vc141-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_cxx-vc142-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_cxx-vc143-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			endif()
		endif(WIN32)
	elseif(C)
		if(WIN32)
			if(MSVC_VERSION EQUAL 1600)
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_c-vc100-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif(MSVC_VERSION EQUAL 1900)
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_c-vc140-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1910) AND (MSVC_VERSION LESS_EQUAL 1919))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_c-vc141-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1920) AND (MSVC_VERSION LESS_EQUAL 1929))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_c-vc142-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			elseif((MSVC_VERSION GREATER_EQUAL 1940) AND (MSVC_VERSION LESS_EQUAL 1949))
				add_custom_command(TARGET ${ProjectName} POST_BUILD
					COMMAND ${CMAKE_COMMAND} -E copy_if_different
					"${LIB_DATA}/lsreader_c-vc143-0_1.dll"
					$<TARGET_FILE_DIR:${ProjectName}>)
			endif()
		endif(WIN32)
	else()
	    message(STATUS "Please input correct language name")
	endif()
endmacro(post_build)

macro(set_bin_dir ProjectName BinName)
    set_target_properties(${ProjectName} PROPERTIES RUNTIME_OUTPUT_DIRECTORY ${PROJECT_BINARY_DIR}/bin/${BinName})
    set_target_properties(${ProjectName} PROPERTIES LIBRARY_OUTPUT_DIRECTORY ${PROJECT_BINARY_DIR}/bin/${BinName})
    set_target_properties(${ProjectName} PROPERTIES ARCHIVE_OUTPUT_DIRECTORY ${PROJECT_BINARY_DIR}/bin/${BinName})
endmacro(set_bin_dir)

    