#include <string.h>
#include <iostream>
#include <vector>

#include "../config.h"
#include "d3plotreader.h"
#include "binoutreader.h"
using namespace std;

int main()
{
	{
		//======================D3plotReader======================
		string d3plot_file = DATA_PATH_D3P;

#ifdef WIN32
		string::size_type pos = d3plot_file.find('/');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "\\");
			pos = d3plot_file.find('/');
		}
#else
		string::size_type pos = d3plot_file.find('\\');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "/");
			pos = d3plot_file.find('\\');
		}
#endif

		D3plotReader dr(d3plot_file.c_str());

		cout << "=============== D3plotReader ===============" << endl;
		char title[80];
		dr.GetData(D3P_TITLE, (char*)title);
		cout << "title: " << title << endl;

		int num_states = 0;
		dr.GetData(D3P_NUM_STATES, (char*)&num_states);
		cout << "num states: " << num_states << endl;

		int num_nodes = 0;
		dr.GetData(D3P_NUM_NODES, (char*)&num_nodes);
		cout << "num nodes: " << num_nodes << endl;

		int* nodal_ids = new int[num_nodes];
		dr.GetData(D3P_NODE_IDS, (char*)nodal_ids);

		int num_shell_elements = 0;
		dr.GetData(D3P_NUM_SHELL, (char*)&num_shell_elements);
		cout << "num shells: " << num_shell_elements << endl;

		D3P_Shell* shells = new D3P_Shell[num_shell_elements];
		dr.GetData(D3P_SHELL_CONNECTIVITY_MAT, (char*)shells);
		cout << "shell_conn[0](" << nodal_ids[shells[0].conn[0] - 1] << ", " << nodal_ids[shells[0].conn[1] - 1] << ", " << nodal_ids[shells[0].conn[2] - 1] << ", " << nodal_ids[shells[0].conn[3] - 1] << ")" << endl;
		delete[] shells;
		delete[] nodal_ids;

		D3P_Parameter param;

		param.ist = 11;
		D3P_Vector* coords = new D3P_Vector[num_nodes];
		dr.GetData(D3P_NODE_COORDINATES, (char*)coords, param);
		cout.precision(6);
		cout << fixed;
		if (!num_nodes)
			cout << "coords[211](" << coords[211].v[0] << ", " << coords[211].v[1] << ", " << coords[211].v[2] << ") at the first state" << endl;

		param.ist = 11;
		dr.GetData(D3P_NODE_COORDINATES, (char*)coords, param);
		cout.precision(10);

		if (!num_nodes)
			cout << "coords[211](" << coords[211].v[0] << ", " << coords[211].v[1] << ", " << coords[211].v[2] << ") at the last state" << endl;
		delete[] coords;

		D3P_VectorDouble* dcoords = new D3P_VectorDouble[num_nodes];
		dr.GetData(D3P_NODE_COORDINATES_DOUBLE, (char*)dcoords, param);
		if (!num_nodes)
			cout << "dcoords[211](" << dcoords[211].v[0] << ", " << dcoords[211].v[1] << ", " << dcoords[211].v[2] << ") at the last state" << endl;
		delete[] dcoords;

		D3P_Tensor* shell_stress = new D3P_Tensor[num_shell_elements];
		param.ipt = 2;
		dr.GetData(D3P_SHELL_STRESS, (char*)shell_stress, param);
		cout.precision(6);
		cout << "shell_stress[0](" << shell_stress[0].t[0] << ", " << shell_stress[0].t[1] << ", " << shell_stress[0].t[2] << ", " << shell_stress[0].t[3] << ", " << shell_stress[0].t[4] << ", " << shell_stress[0].t[5] << ")" << endl;
		delete[] shell_stress;

		float* shell_history_var = new float[num_shell_elements];
		param.ist = 0;
		param.ipt = 0;
		param.ihv = 1;
		dr.GetData(D3P_SHELL_HISTORY_VAR, (char*)shell_history_var, param);
		cout << "shell_history_var[0]: " << shell_history_var[0] << "\n" << endl;
		delete[] shell_history_var;
	}
	
	{
		//======================BinoutReader======================
		string binout_file = DATA_PATH_BINOUT;
		string output = OUTPUT_PATH_CXX;

#ifdef WIN32
		string::size_type pos = binout_file.find('/');
		while (pos != string::npos)
		{
			binout_file.replace(pos, 1, "\\");
			pos = binout_file.find('/');
		}
		pos = output.find('/');
		while (pos != string::npos)
		{
			output.replace(pos, 1, "\\");
			pos = output.find('/');
		}
#else
		pos = binout_file.find('\\');
		while (pos != string::npos)
		{
			binout_file.replace(pos, 1, "/");
			pos = binout_file.find('\\');
		}
		pos = output.find('\\');
		while (pos != string::npos)
		{
			output.replace(pos, 1, "/");
			pos = output.find('\\');
		}
#endif

		cout << "\n\n=============== BinoutReader ===============" << endl;

		bool ret = BinoutReader::IsValid(binout_file.c_str());

		BinoutReader br(binout_file.c_str());

		BinoutStringArray branches;
		br.GetBranch(branches);
		cout << "Branches: " << endl;
		for (size_t i = 0; i < branches.size(); i++)
		{
			cout << branches[i] << ",";
		}
		cout << "\n" << endl;

		br.SetBranch("nodout");
		br.SetId(1787);
		br.SetComponent("x_acceleration");

		std::vector<double> x_array;
		std::vector<double> y_array;
		br.GetXArray(x_array);
		br.GetYArray(y_array);

		cout << "Branch=\"nodout\", id=\"1787\", component=\"x_acceleration\"" << endl;
		cout << "x_array,    y_array:" << endl;
		for (size_t i = 0; i < 20; i++)
		{
			cout << x_array[i] << ",   " << y_array[i] << endl;
		}
		cout << "..." << endl;
	}

	{
		//======================D3plotReader catch exception======================
		std::string d3plot_file = DATA_PATH_D3P;

#ifdef WIN32
		string::size_type pos = d3plot_file.find('/');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "\\");
			pos = d3plot_file.find('/');
		}
#else
		string::size_type pos = d3plot_file.find('\\');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "/");
			pos = d3plot_file.find('\\');
		}
#endif

		cout << "=============== D3plotReader ===============" << endl;
		try {
			D3plotReader dr(d3plot_file.c_str());

			int num_states = 0;
			dr.GetData(D3P_NUM_STATES, (char*)&num_states);
			cout << "num states: " << num_states << endl;

			D3P_Parameter dp;
			dp.ist = 0;
			dp.ipt = 0;
			std::vector<D3P_Tensor> shellStress = dr.GetDataTensorArray(D3P_SHELL_STRESS, dp);
			cout.precision(6);
			cout << "shell_stress[0](" << shellStress[0].t[0] << ", " << shellStress[0].t[1] << ", " << shellStress[0].t[2] << ", " << shellStress[0].t[3] << ", " << shellStress[0].t[4] << ", " << shellStress[0].t[5] << ")" << endl;
		}
		catch (const D3plotException& e){
			D3P_ReturnType type = e.GetReturnType();
			switch (type)
			{
			case D3P_ERROR_PARAMETER:
				std::cout << "parameter error" << std::endl;
				break;
			case D3P_ERROR_FREAD:
				std::cout << "read file error" << std::endl;
				break;
			case D3P_ERROR_FREAD_FEMZIP:
				std::cout << "read femzip file error" << std::endl;
				break;
			case D3P_ERROR_FREAD_UNRECOGNIZED:
				std::cout << "read unrecognized file error" << std::endl;
				break;
			case D3P_ERROR_FREAD_NONEXISTENT:
				std::cout << "file is nonexistent" << std::endl;
				break;
			case D3P_WARNING_NO_DATA:
				std::cout << "no data in database" << std::endl;
				break;
			case D3P_WARNING_NO_ELEM:
				std::cout << "no element in database" << std::endl;
				break;
			case D3P_ERROR:
				std::cout << "other error" << std::endl;
				break;
			default:
				break;
			}
		}
	}

	{
		//====================== D3max ======================
		std::string d3plot_file = DATA_PATH_D3MAX;

#ifdef WIN32
		string::size_type pos = d3plot_file.find('/');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "\\");
			pos = d3plot_file.find('/');
		}
#else
		string::size_type pos = d3plot_file.find('\\');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "/");
			pos = d3plot_file.find('\\');
		}
#endif

		cout << "=============== D3max ===============" << endl;
		D3plotReader dr(d3plot_file.c_str());

		int num_states = 0;
		dr.GetData(D3P_NUM_STATES, (char*)&num_states);
		cout << "num states: " << num_states << endl;

		bool hasSolidStress = dr.GetDataBool(D3P_HAS_SOLID_STRESS);
		bool hasShellStress = dr.GetDataBool(D3P_HAS_SHELL_STRESS);

		D3P_Parameter dp;
		dp.ist = 0;
		std::vector<D3P_Tensor> solidStress = dr.GetDataTensorArray(D3P_SOLID_STRESS, dp);
		std::vector<D3P_Tensor> shellStress = dr.GetDataTensorArray(D3P_SHELL_STRESS, dp);
		dp.ipt = 0;
	}

#ifdef WIN32
	system("pause");
#endif
}
