#ifndef __BINOUT_READER_WRAPPER_C_H__
#define __BINOUT_READER_WRAPPER_C_H__

#ifdef WIN32
#if defined (LSREADER_C_STATIC_LIB)
#define CREADERAPI
#else
#if defined (lsreader_c_EXPORTS)
#define CREADERAPI __declspec(dllexport)
#else // outside DLL
#define CREADERAPI __declspec(dllimport)
#endif
#endif

#else
#define CREADERAPI
#endif

#include <stddef.h>

#ifndef __BINOUT_DATA_TYPE_ENUMERATIONS__
#define __BINOUT_DATA_TYPE_ENUMERATIONS__

enum BINOUT_IdType
{
	/*  initial value for idtype*/
	BINOUT_IDTYPE_NONE,

	/*  ID type in Elout branch*/
	BINOUT_ELOUT_ID_BEAM,
	BINOUT_ELOUT_ID_SHELL,
	BINOUT_ELOUT_ID_SOLID,
	BINOUT_ELOUT_ID_TSHELL,
	/*  ID type in Swforc branch*/
	BINOUT_SWFORC_ID_CONSTRAINT,
	BINOUT_SWFORC_ID_WELD,
	BINOUT_SWFORC_ID_BEAM,
	BINOUT_SWFORC_ID_SOLID,
	BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT,
	BINOUT_SWFORC_ID_SOLID_ASSEMBLY,

	/*  ID type in Abstat branch*/
	BINOUT_ABSTAT_ID_AIRBAG,
	BINOUT_ABSTAT_ID_MATERIAL,

	/*  ID type in Abstat_pbm branch*/
	BINOUT_ABSTAT_PBM_ID_PBLAST,
	BINOUT_ABSTAT_PBM_ID_PART,

	/*  ID type in Nodfor branch*/
	BINOUT_NODFOR_ID_NODE,
	BINOUT_NODFOR_ID_GROUP,

	/* ID type in rcforc branch*/
	BINOUT_RCFORC_ID_MASTER,
	BINOUT_RCFORC_ID_SLAVE,

	/* ID type in sbtout branch*/
	BINOUT_SBTOUT_ID_BELT,
	BINOUT_SBTOUT_ID_RETRACTOR,
	BINOUT_SBTOUT_ID_SLIPRING,

	/*ID type in bndout branch*/
	BINOUT_BNDOUT_ID_DISCRETENODES,
	BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	BINOUT_BNDOUT_ID_PRESSURE,
	BINOUT_BNDOUT_ID_VELOCITYNODES,
	BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
	BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,

	/*ID type in nbndout branch*/
	BINOUT_NBNDOUT_ID_DISCRETENODES,
	BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
	BINOUT_NBNDOUT_ID_PRESSURE,
	BINOUT_NBNDOUT_ID_VELOCITYNODES,
	BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
	BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,

	/*ID type in jntforc branch*/
	BINOUT_JNTFORC_ID_JOINTS,
	BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED,

	/*ID type in spcforc*/
	BINOUT_SPCFORC_SETID,
	BINOUT_SPCFORC_ID,

	/*ID type in rwforc*/
	BINOUT_RWFORC_ID_FORCES,
	BINOUT_RWFORC_ID_TRANSDUCER,
	BINOUT_RWFORC_ID_WALL,

	/*ID type in nodfor_ssd */
	BINOUT_NODFOR_SSD_ID_NODE,
	BINOUT_NODFOR_SSD_ID_GROUP,

	/*ID type in elout_ssd*/
	BINOUT_ELOUT_SSD_ID_BEAM,
	BINOUT_ELOUT_SSD_ID_SOLID,
	BINOUT_ELOUT_SSD_ID_TSHELL,
	BINOUT_ELOUT_SSD_ID_SHELL,

	/*ID type in eloutdet*/
	BINOUT_ELOUTDET_ID_SOLID,
	BINOUT_ELOUTDET_ID_SHELL,
	BINOUT_ELOUTDET_ID_TSHELL,
	BINOUT_ELOUTDET_ID_NODAVG,

	/*ID type in abstat_cpm*/
	BINOUT_ABSTATCPM_ID_BAG,
	BINOUT_ABSTATCPM_ID_PART,
	BINOUT_ABSTATCPM_ID_SPECIES,
	BINOUT_ABSTATCPM_ID_CHAMBER,

	/*ID type in elout_psd*/
	BINOUT_ELOUT_PSD_ID_BEAM,
	BINOUT_ELOUT_PSD_ID_SOLID,
	BINOUT_ELOUT_PSD_ID_TSHELL,
	BINOUT_ELOUT_PSD_ID_SHELL,

	/*ID type in elout_spcm*/
	BINOUT_ELOUT_SPCM_ID_BEAM,
	BINOUT_ELOUT_SPCM_ID_SOLID,
	BINOUT_ELOUT_SPCM_ID_TSHELL,
	BINOUT_ELOUT_SPCM_ID_SHELL,
    
    /*ID type in abstat_cpg*/
	BINOUT_ABSTATCPG_ID_BAG,
	BINOUT_ABSTATCPG_ID_PART,
};
enum BINOUT_DataTypeOption
{
	/* initial value for option*/
	BINOUT_DATATYPE_GENERAL,

	/* values for nodout_ssd,nodfor_ssd,elout_ssd files */
	BINOUT_DATATYPE_AMPLITUDE,
	BINOUT_DATATYPE_PHASEANGLE,
	BINOUT_DATATYPE_REAL,
	BINOUT_DATATYPE_IMAGINARY,
	BINOUT_DATATYPE_MODALCONTRIBUTION,

	/*eloutdet ipt or nqt*/
	BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS,
	BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,

	/*elout lower or upper the option is only used for strain x, y, z, xy, xz, yz*/
	BINOUT_DATATYPE_ELOUT_LOWER,
	BINOUT_DATATYPE_ELOUT_UPPER,

};
enum BINOUT_DataType
{

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NUM_BRANCH,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NUM_BRANCH
     * parameters: ignore
     */
    BINOUT_BRANCHES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ABSTAT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTAT_NUM_ID
     * parameters: ignore
     */
    BINOUT_ABSTAT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ABSTAT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_ABSTAT_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_NUM_MATID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTAT_NUM_MATID
     * parameters: ignore
     */
    BINOUT_ABSTAT_MAT_IDS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_AREA_BLOCKED,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_AREA_UNBLOCKED,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_LEAKAGE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_DT_IN,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_DT_OUT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_DT_OUTP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_DT_OUTV,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_IN,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_OUT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_OUTP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_DM_OUTV,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_GAS_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_REACTION,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_AREA_SURFACE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_TOTAL_MASS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_ABSTAT_VOLUME,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTAT_PBM_NUM_ID
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ABSTAT_PBM_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_NUM_PARTID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTAT_PBM_NUM_PARTID
     * parameters: ignore
     */
    BINOUT_ABSTAT_PBM_PART_IDS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_AIR_INTER_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_AIR_TRANS_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_DETONATION_PRODUCT_INTER_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_DETONATION_PRODUCT_TRANS_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_OUTSIDE_DOMAIN_INTER_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_OUTSIDE_DOMAIN_TRANS_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_PRESSURE_AIR,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_PRESSURE_DET_PRODUCTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_PRESSURE_RESULTANT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_SURFACE_AREA,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_X_FORCE_AIR,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_X_FORCE_DET_PRODUCTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_X_FORCE_RESULTANT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Y_FORCE_AIR,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Y_FORCE_DET_PRODUCTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Y_FORCE_RESULTANT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Z_FORCE_AIR,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Z_FORCE_DET_PRODUCTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTAT_PBM_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_PBM_ID_PBLAST or BINOUT_ABSTAT_PBM_ID_PART
     */
    BINOUT_ABSTAT_PBM_Z_FORCE_RESULTANT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTATCPG_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ABSTATCPG_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype
     */
    BINOUT_ABSTATCPG_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTATCPG_NUM_ID
     * parameters: idtype
     */
    BINOUT_ABSTATCPG_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype
     */
    BINOUT_ABSTATCPG_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ABSTATCPG_NUM_COMPONENT
     * parameters: idtype
     */
    BINOUT_ABSTATCPG_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_AREA,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_AVERAGE_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_AVERAGE_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_AVERAGE_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_AVERAGE_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_EXACT_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_EXACT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_EXACT_MASS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_EXACT_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_EXACT_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_NPARTICLES,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_VOLUME,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_WORK_ATMOSPHERIC,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_BAG,  id is bagid
     */
    BINOUT_ABSTATCPG_WORK_USEFUL,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_AREAS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_FORCES_X,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_FORCES_Y,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_FORCES_Z,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_HEAT_TRANSFER,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_HEAT_TRANSFER_RATE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_LEAKAGE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_MFRATE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_PSTAT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_TSTAT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPG_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPG_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPG_PART_VFRAT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ABSTATCPM_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ABSTATCPM_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype
     */
    BINOUT_ABSTATCPM_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ABSTATCPM_NUM_ID
     * parameters: idtype
     */
    BINOUT_ABSTATCPM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype
     */
    BINOUT_ABSTATCPM_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ABSTATCPM_NUM_COMPONENT
     * parameters: idtype
     */
    BINOUT_ABSTATCPM_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_VOLUME,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_DM_DT_IN,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_DM_DT_OUT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_TOTAL_MASS,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_GAS_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_SURFACE_AREA,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_REACTION,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG or BINOUT_ABSTATCPM_ID_CHAMBER, id is bagid or chamber id
     */
    BINOUT_ABSTATCPM_PRES_PARTICLE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG,id is bagid.
     */
    BINOUT_ABSTATCPM_INFLATOR_E,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_BAG,id is bagid.
     */
    BINOUT_ABSTATCPM_TRANS_KE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_POR_LEAK,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_VENT_LEAK,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_AREA_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_AREA_UNBLOCKED,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_PRESP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_PRESM,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_HEAT_CONVECTION,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_ENHANCE_VENT,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_LEAK_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_PART_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_PART, id = bagid (default is the first bag id), partid.
     */
    BINOUT_ABSTATCPM_POR_VOLUME,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_SPECIES, id = bagid, partid, speciesid(air is 0).
     */
    BINOUT_ABSTATCPM_NT_SPECIES,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_CHAMBER
     */
    BINOUT_ABSTATCPM_NUMPARTICLE,

    /**
     * conversion: double
     * length    : BINOUT_ABSTATCPM_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ABSTATCPM_ID_CHAMBER
     */
    BINOUT_ABSTATCPM_TRANSE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_CPMSENSOR_NUM_ID
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_CPMSENSOR_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_AVE_VELX,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_AVE_VELY,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_AVE_VELZ,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_AVE_VELR,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_RHO,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_SENSOR_X,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_SENSOR_Y,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_SENSOR_Z,

    /**
     * conversion: double
     * length    : BINOUT_CPMSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CPMSENSOR_NPART,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSENSOR_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSENSOR_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PGSENSOR_NUM_ID
     * parameters: ignore
     */
    BINOUT_PGSENSOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSENSOR_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PGSENSOR_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_PGSENSOR_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_AVE_VELX,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_AVE_VELY,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_AVE_VELZ,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_AVE_VELR,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_RHO,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_SENSOR_X,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_SENSOR_Y,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_SENSOR_Z,

    /**
     * conversion: double
     * length    : BINOUT_PGSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSENSOR_NPART,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSTAT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_BAG_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PGSTAT_NUM_BAG_ID
     * parameters: ignore
     */
    BINOUT_PGSTAT_BAG_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_PART_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PGSTAT_NUM_PART_ID
     * parameters: ignore
     */
    BINOUT_PGSTAT_PART_IDS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_CHAMBER_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PGSTAT_NUM_CHAMBER_ID
     * parameters: ignore
     */
    BINOUT_PGSTAT_CHAMBER_IDS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_ABSTAT_ID_AIRBAG or BINOUT_ABSTAT_ID_MATERIAL
     */
    BINOUT_PGSTAT_NUM_BAG_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PGSTAT_NUM_BAG_COMPONENT
     * parameters: ignore
     */
    BINOUT_PGSTAT_BAG_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_PART_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PGSTAT_NUM_PART_COMPONENT
     * parameters: ignore
     */
    BINOUT_PGSTAT_PART_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PGSTAT_NUM_CHAMBER_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PGSTAT_NUM_CHAMBER_COMPONENT
     * parameters: ignore
     */
    BINOUT_PGSTAT_CHAMBER_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_POR_LEAK,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_VENT_LEAK,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_AREA_TOT,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_AREA_UNBLOCKED,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_PRES_PLUS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_PART_PRES_MINUS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_VOLUME,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_DM_DT_IN,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_DM_DT_OUT,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_TOTAL_MASS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_GAS_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_SURFACE_AREA,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_BAG_REACTION,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_VOLUME,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_DM_DT_IN,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_DM_DT_OUT,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_TOTAL_MASS,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_GAS_TEMP,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_SURFACE_AREA,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_REACTION,

    /**
     * conversion: double
     * length    : BINOUT_PGSTAT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PGSTAT_CHAMBER_TRANSE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DISBOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DISBOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DISBOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DISBOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_DISBOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DISBOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DISBOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DISBOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_DISPLACEMENT_AXIS,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_DISPLACEMENT_S,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_DISPLACEMENT_T,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_ROTATION_AXIS,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_ROTATION_S,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_RELATIVE_ROTATION_T,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_FORCE_AXIS,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_FORCE_S,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_FORCE_T,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_MOMENET_AXIS,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_MOMENET_S,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_MOMENET_T,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_AXIS_X,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_AXIS_Y,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_AXIS_Z,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_S_X,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_S_Y,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_S_Z,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_T_X,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_T_Y,

    /**
     * conversion: double
     * length    : BINOUT_DISBOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DISBOUT_DIRECTION_T_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMFLOW_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DEMFLOW_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DEMFLOW_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMFLOW_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEMFLOW_NUM_ID
     * parameters: ignore
     */
    BINOUT_DEMFLOW_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMFLOW_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DEMFLOW_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DEMFLOW_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DEMFLOW_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMFLOW_MFLOW_PLUS,

    /**
     * conversion: double
     * length    : BINOUT_DEMFLOW_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMFLOW_MFLOW_MINUS,

    /**
     * conversion: double
     * length    : BINOUT_DEMFLOW_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMFLOW_MFLOW_RESULTANT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMTRH_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DEMTRH_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMTRH_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEMTRH_NUM_ID
     * parameters: ignore
     */
    BINOUT_DEMTRH_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMTRH_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DEMTRH_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DEMTRH_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_POSITION_X,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_POSITION_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_POSITION_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_VELOCITY_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_X,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_POROSITY,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_VOID_RATIO,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_COORD_NUMBER,

    /**
     * conversion: double
     * length    : BINOUT_DEMTRH_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_DEMTRH_PRESSURE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PBLAST_SENSOR_NUM_ID
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PBLAST_SENSOR_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_PBLAST_SENSOR_COMPONENTS,

    /**
     * conversion: int
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_COUNTS,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_COORD_X,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_COORD_Y,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_COORD_Z,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_PBLAST_SENSOR_NUM_TIMESTEP
     * parameters: id, idtype
     */
    BINOUT_PBLAST_SENSOR_PRESSURE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PLLYOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_PLLYOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PLLYOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PLLYOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PLLYOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_PLLYOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PLLYOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PLLYOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_PLLYOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_PLLYOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PLLYOUT_SLIP,

    /**
     * conversion: double
     * length    : BINOUT_PLLYOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PLLYOUT_SLIP_RATE,

    /**
     * conversion: double
     * length    : BINOUT_PLLYOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PLLYOUT_RESULTANT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_PLLYOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PLLYOUT_WRAP_ANGLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHFLOW_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SPHFLOW_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPHFLOW_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHFLOW_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPHFLOW_NUM_ID
     * parameters: ignore
     */
    BINOUT_SPHFLOW_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHFLOW_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SPHFLOW_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SPHFLOW_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SPHFLOW_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHFLOW_MFLOW_PLUS,

    /**
     * conversion: double
     * length    : BINOUT_SPHFLOW_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHFLOW_MFLOW_MINUS,

    /**
     * conversion: double
     * length    : BINOUT_SPHFLOW_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHFLOW_MFLOW_RESULTANT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPHOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPHOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_SPHOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SPHOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SPHOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_X,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_Y,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_Z,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_X,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_Y,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_Z,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_RADIUS_OF_INFLUNCE,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_YIELD,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_EFFECTIVE_STRESS,

    /**
     * conversion: double
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_TEMPERATURE,

    /**
     * conversion: int
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_NUMBER_OF_NEIGHBORS,

    /**
     * conversion: int
     * length    : BINOUT_SPHOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHOUT_ACT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRALEH_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_TRALEH_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRALEH_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_TRALEH_NUM_ID
     * parameters: ignore
     */
    BINOUT_TRALEH_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRALEH_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_TRALEH_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_TRALEH_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_POSITION_X,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_POSITION_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_POSITION_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_VELOCITY_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_X,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_DENSITY,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_VOLUME_FRACTION,

    /**
     * conversion: double
     * length    : BINOUT_TRALEH_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRALEH_HISTORY_VAR,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_NODFOR_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODFOR_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODFOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_NUM_GROUPID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODFOR_NUM_GROUPID
     * parameters: ignore
     */
    BINOUT_NODFOR_GROUP_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODFOR_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODFOR_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype=BINOUT_NODFOR_ID_NODE
     */
    BINOUT_NODFOR_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype=BINOUT_NODFOR_ID_NODE
     */
    BINOUT_NODFOR_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype=BINOUT_NODFOR_ID_NODE
     */
    BINOUT_NODFOR_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype=BINOUT_NODFOR_ID_NODE
     */
    BINOUT_NODFOR_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_TOTAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_TOTAL_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_TOTAL_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_TOTAL_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_LOCAL_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_LOCAL_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_NUM_TIMESTEP
     * parameters: id, idtype= BINOUT_NODFOR_ID_GROUP
     */
    BINOUT_NODFOR_LOCAL_FORCE_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_NODOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_COORDINATE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_COORDINATE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_ACCELERATION_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_COORDINATE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUT_VELOCITY_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUTHF_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_NODOUTHF_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUTHF_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODOUTHF_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODOUTHF_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUTHF_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODOUTHF_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODOUTHF_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_RX,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_RY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_RZ,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_COORDINATE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_COORDINATE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_ACCELERATION_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_COORDINATE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUTHF_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_NODOUTHF_VELOCITY_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_NUM_ID
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ELOUT_NUM_COMPONENT
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NUM_IPT,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_NUM_IPT
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_IPTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NUM_NPL,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_NUM_NPL
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,
     */
    BINOUT_ELOUT_NPLS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_YIELD,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_EFFSG,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_PLASTIC_STRAIN,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_AXIAL,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_SHEAR_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_SHEAR_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_MOMENT_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_MOMENT_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_TORSION,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_COEF_LENGTH,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_VISC_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_SIGMA_11,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_SIGMA_12,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_SIGMA_31,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_PLASTIC_EPS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_NUM_TIMESTEP
     * parameters: idtype = BINOUT_ELOUT_ID_BEAM,BINOUT_ELOUT_ID_SHELL,BINOUT_ELOUT_ID_SOLID or BINOUT_ELOUT_ID_TSHELL,id, ipt, npl
     */
    BINOUT_ELOUT_HISTORY_VAR,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SSSTAT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SSSTAT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SSSTAT_NUM_SYSTEMS,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SSSTAT_NUM_SYSTEMS
     * parameters: ignore
     */
    BINOUT_SSSTAT_SYSTEM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SSSTAT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SSSTAT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SSSTAT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SSSTAT_TIME_STEP,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SSSTAT_KIN_ENERGY_G,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SSSTAT_INT_ENERGY_G,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SSSTAT_HGL_ENERGY_G,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_HOURGLASS_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MOMENTUM_X,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MOMENTUM_Y,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MOMENTUM_Z,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_KINETIC_ENERGY_RATIOS,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INTERNAL_ENERGY_RATIOS,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_TOTALMASS_SUBSYSTEM,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MASSCENTER_COORDINATE_X,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MASSCENTER_COORDINATE_Y,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_MASSCENTER_COORDINATE_Z,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_XX,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_XY,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_XZ,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_YY,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_YZ,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_INERTIA_TENSOR_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_1ST,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_2ND,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_3RD,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_1ST_DIRECTIONS_X,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_1ST_DIRECTIONS_Y,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_1ST_DIRECTIONS_Z,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_2ND_DIRECTIONS_X,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_2ND_DIRECTIONS_Y,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_2ND_DIRECTIONS_Z,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_3RD_DIRECTIONS_X,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_3RD_DIRECTIONS_Y,

    /**
     * conversion: double
     * length    : BINOUT_SSSTAT_NUM_TIMESTEP
     * parameters: systemid
     */
    BINOUT_SSSTAT_PRINCIPAL_INERTIAS_3RD_DIRECTIONS_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GLSTAT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GLSTAT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_GLSTAT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_GLSTAT_COMPONENTS,

    /**
     * conversion: int
     * length    : BINOUT_GLSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_NUMBER_OF_NODES,

    /**
     * conversion: int
     * length    : BINOUT_GLSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_NUMBER_OF_ELEMENTS,

    /**
     * conversion: int
     * length    : BINOUT_GLSTAT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_NZC,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GLSTAT_NUMBER_OF_STONEWALL,

    /**
     * conversion: unsigned int
     * length    : BINOUT_GLSTAT_NUMBER_OF_STONEWALL
     * parameters: ignore
     */
    BINOUT_GLSTAT_STONEWALL_IDS,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_TIME_STEP,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_RB_STOPPER_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_SPRING_AND_DAMPER_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_JOINT_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_HOURGLASS_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_SYSTEM_DAMPING_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_SLIDING_INTERFACE_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_EXTERNAL_WORK,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ERODED_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ERODED_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ERODED_HOURGLASS_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_TOTAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ENERGY_RATIO,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ENERGY_RATIO_WO_ERODED,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_GLOBAL_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_GLOBAL_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_GLOBAL_VELOCITY_Z,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_ADDED_MASS,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_PERCENT_INCREASE,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_TOTAL_MASS,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_MASS_CENTER_X,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_MASS_CENTER_Y,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: ignore
     */
    BINOUT_GLSTAT_MASS_CENTER_Z,

    /**
     * conversion: double
     * length    : BINOUT_GLSTAT_TIME_STEP
     * parameters: stonewallid
     */
    BINOUT_GLSTAT_STONEWALL_ENERGY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DEFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFORC_NUM_TRANSLATION_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEFORC_NUM_TRANSLATION_ID
     * parameters: ignore
     */
    BINOUT_DEFORC_TRANSLATION_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFORC_NUM_ROTATION_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEFORC_NUM_ROTATION_ID
     * parameters: ignore
     */
    BINOUT_DEFORC_ROTATION_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DEFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DEFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_DISPLACEMENT,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_RESULTANT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_RELATIVE_ROTATION,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_RESULTANT_MOMENT,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEFORC_NUM_TIMESTEP
     * parameters: id = spring/damper number
     */
    BINOUT_DEFORC_MOMENT_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_MATSUM_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_MATSUM_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_MATSUM_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_MATSUM_NUM_ID
     * parameters: ignore
     */
    BINOUT_MATSUM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_MATSUM_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_MATSUM_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_MATSUM_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_ERODED_INTERNAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_ERODED_KINETIC_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_MASS,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_HOURGLASS_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_MOMENTUM_X,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_MOMENTUM_Y,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_MOMENTUM_Z,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_RBVELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_RBVELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_MATSUM_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_MATSUM_RBVELOCITY_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRHIST_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_TRHIST_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRHIST_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_TRHIST_NUM_ID
     * parameters: ignore
     */
    BINOUT_TRHIST_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TRHIST_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_TRHIST_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_TRHIST_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_ELEMENT_ID,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_COORDINATE_X,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_COORDINATE_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_COORDINATE_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_VELOCITY_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_X,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_Y,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_Z,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_REL_VOL,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_RHO,

    /**
     * conversion: double
     * length    : BINOUT_TRHIST_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TRHIST_PRESSURE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TPRINT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_TPRINT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TPRINT_NUM_NODE_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TPRINT_NUM_PART_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_TPRINT_NUM_ID
     * parameters: ignore
     */
    BINOUT_TPRINT_NODE_IDS,

    /**
     * conversion: unsigned int
     * length    : BINOUT_TPRINT_NUM_ID
     * parameters: ignore
     */
    BINOUT_TPRINT_PART_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TPRINT_NUM_NODE_COMPONENT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_TPRINT_NUM_PART_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_TPRINT_NUM_NODE_COMPONENT
     * parameters: ignore
     */
    BINOUT_TPRINT_NODE_COMPONENTS,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_TPRINT_NUM_PART_COMPONENT
     * parameters: ignore
     */
    BINOUT_TPRINT_PART_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_FLUX_X,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_FLUX_Y,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_FLUX_Z,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_T_TOP,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_T_BOTTOM,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_AVERAGE_PART_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_ENERGY_CHANGE,

    /**
     * conversion: double
     * length    : BINOUT_TPRINT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_TPRINT_HEAT_GENERATED,

    /**
     * conversion: double
     * length    : 1
     * parameters: state number
     */
    BINOUT_TPRINT_TMIN,

    /**
     * conversion: double
     * length    : 1
     * parameters: state number
     */
    BINOUT_TPRINT_TMAX,

    /**
     * conversion: double
     * length    : 1
     * parameters: state number
     */
    BINOUT_TPRINT_TNORM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NCFORC_NUM_INTERFACE,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NCFORC_NUM_INTERFACE
     * parameters: ignore
     */
    BINOUT_NCFORC_INTERFACES,

    /**
     * conversion: int
     * length    : 1
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NCFORC_NUM_ID
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_NUM_SLAVEID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NCFORC_NUM_SLAVEID
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_SLAVE_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_NUM_MASTERID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NCFORC_NUM_MASTERID
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_MASTER_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NCFORC_NUM_COMPONENT,
     * parameters: cid = contact id
     */
    BINOUT_NCFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_COORDINATE_X,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_COORDINATE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NCFORC_NUM_TIMESTEP
     * parameters: cid = contact id, id = master/slave node id
     */
    BINOUT_NCFORC_COORDINATE_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RCFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_RCFORC_NUM_ID
     * parameters: ignore
     */
    BINOUT_RCFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RCFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_RCFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RCFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_RCFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_RCFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_MASS,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_TIE_AREA,

    /**
     * conversion: int
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_TIE_COUNT,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_RESULTANT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_RCFORC_NUM_TIMESTEP
     * parameters: id, idtype: BINOUT_RCFORC_ID_MASTER, BINOUT_RCFORC_ID_SLAVE
     */
    BINOUT_RCFORC_MOMENT_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SECFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SECFORC_NUM_ID
     * parameters: ignore
     */
    BINOUT_SECFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SECFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SECFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SECFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SECFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SECFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_FORCE_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_CENTROID_X,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_CENTROID_Y,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_CENTROID_Z,

    /**
     * conversion: double
     * length    : BINOUT_SECFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SECFORC_AREA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DCFAIL_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DCFAIL_NUM_ID
     * parameters: ignore
     */
    BINOUT_DCFAIL_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DCFAIL_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DCFAIL_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DCFAIL_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DCFAIL_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DCFAIL_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_AREA,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_BENDING_TERM,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_EFFECTIVE_STRAIN_RATE,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_FAILURE_FUNCTION,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_NORMAL_TERM,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_SHEAR_TERM,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_AREA_SOL,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_AXIAL_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_SHEAR_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_TORSIONAL_MOMENT,

    /**
     * conversion: double
     * length    : BINOUT_DCFAIL_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DCFAIL_BENDING_MOMENT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PRTUBE_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_PRTUBE_NUM_ID
     * parameters: ignore
     */
    BINOUT_PRTUBE_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PRTUBE_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_PRTUBE_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_PRTUBE_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_PRTUBE_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_PRTUBE_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_PRTUBE_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_PRTUBE_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PRTUBE_AREA,

    /**
     * conversion: double
     * length    : BINOUT_PRTUBE_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PRTUBE_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_PRTUBE_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PRTUBE_VELOCITY,

    /**
     * conversion: double
     * length    : BINOUT_PRTUBE_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_PRTUBE_DENSITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GCEOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_GCEOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_GCEOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GCEOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_GCEOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_GCEOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_GCEOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_GCEOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_FORCE_MAGNITUDE,

    /**
     * conversion: double
     * length    : BINOUT_GCEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_GCEOUT_MOMENT_MAGNITUDE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFGEO_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEFGEO_NUM_ID
     * parameters: ignore
     */
    BINOUT_DEFGEO_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFGEO_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DEFGEO_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DEFGEO_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEFGEO_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DEFGEO_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DEFGEO_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DEFGEO_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEFGEO_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_DEFGEO_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEFGEO_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEFGEO_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEFGEO_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEFGEO_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEFGEO_DISPLACEMENT_MAX,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DEMRCFORC_NUM_ID
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DEMRCFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DEMRCFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_TOTAL_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_TOTAL_MOMENT,

    /**
     * conversion: double
     * length    : BINOUT_DEMRCFORC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DEMRCFORC_MASS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_BRNGOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_BRNGOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_BRNGOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_BRNGOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_BRNGOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_BRNGOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_BRNGOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_BRNGOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFXG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFYG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFZG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FMXG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FMYG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FMZG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFX,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFY,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FFZ,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FMX,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_FMY,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DXG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DYG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DZG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_AXG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_AYG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_AZG,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DXL,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DYL,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_DZL,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_BXL,

    /**
     * conversion: double
     * length    : BINOUT_BRNGOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_BRNGOUT_BYL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBFSI_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DBFSI_NUM_ID
     * parameters: ignore
     */
    BINOUT_DBFSI_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBFSI_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DBFSI_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBFSI_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DBFSI_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DBFSI_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_FX,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_FY,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_FZ,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_PRES,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_MOUT,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_PLEAK,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_OBSOLETE,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_FLUX,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_GX,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_GY,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_GZ,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_PTMP,

    /**
     * conversion: double
     * length    : BINOUT_DBFSI_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBFSI_PDT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SBTOUT_NUM_BELT_ID,

    /**
     * conversion: usigned int
     * length    : BINOUT_SBTOUT_NUM_BELT_ID
     * parameters: ignore
     */
    BINOUT_SBTOUT_BELT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SBTOUT_NUM_RETRACTOR_ID,

    /**
     * conversion: usigned int
     * length    : BINOUT_SBTOUT_NUM_RETRACTOR_ID
     * parameters: ignore
     */
    BINOUT_SBTOUT_RETRACTOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SBTOUT_NUM_SLIPRING_ID,

    /**
     * conversion: usigned int
     * length    : BINOUT_SBTOUT_NUM_SLIPRING_ID
     * parameters: ignore
     */
    BINOUT_SBTOUT_SLIPRING_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SBTOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SBTOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SBTOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SBTOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SBTOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_BELT
     */
    BINOUT_SBTOUT_BELT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_BELT
     */
    BINOUT_SBTOUT_BELT_LENGTH,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_RETRACTOR
     */
    BINOUT_SBTOUT_RETRACTOR_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_RETRACTOR
     */
    BINOUT_SBTOUT_RETRACTOR_PULL_OUT,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_SLIPRING
     */
    BINOUT_SBTOUT_RING_SLIP,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_SLIPRING
     */
    BINOUT_SBTOUT_RING_FORCEBELT1,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_SLIPRING
     */
    BINOUT_SBTOUT_RING_FORCEBELT2,

    /**
     * conversion: double
     * length    : BINOUT_SBTOUT_TIMESTEP
     * parameters: id, idtype: BINOUT_SBTOUT_ID_SLIPRING
     */
    BINOUT_SBTOUT_RING_WARPANG_THET,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype
     */
    BINOUT_BNDOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP,
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_NUM_ID,

    /**
     * conversion: usigned int
     * length    : BINOUT_BNDOUT_NUM_ID
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_BNDOUT_NUM_COMPONENT
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_RESULTANT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_TOTAL_X,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_TOTAL_Y,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_TOTAL_Z,

    /**
     * conversion: double
     * length    : BINOUT_BNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_BNDOUT_ID_DISCRETENODES,
	                        BINOUT_BNDOUT_ID_DISCRETERIGIDBODIES,
	                        BINOUT_BNDOUT_ID_PRESSURE,
	                        BINOUT_BNDOUT_ID_VELOCITYNODES,
							BINOUT_BNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_BNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_BNDOUT_ETOTAL,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP,
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_NUM_ID,

    /**
     * conversion: usigned int
     * length    : BINOUT_NBNDOUT_NUM_ID
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NBNDOUT_NUM_COMPONENT
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							    BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							    BINOUT_NBNDOUT_ID_PRESSURE,
							    BINOUT_NBNDOUT_ID_VELOCITYNODES,
							    BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							    BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_TOTAL_X,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_TOTAL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_TOTAL_Z,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP
     * parameters: idtype = 	BINOUT_NBNDOUT_ID_DISCRETENODES,
							BINOUT_NBNDOUT_ID_DISCRETERIGIDBODIES,
							BINOUT_NBNDOUT_ID_PRESSURE,
							BINOUT_NBNDOUT_ID_VELOCITYNODES,
							BINOUT_NBNDOUT_ID_VELOCITYRIGIDBODIES,
							BINOUT_NBNDOUT_ID_ORIENTATIONRIGIDBODIES,
     */
    BINOUT_NBNDOUT_ETOTAL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_JNTFORC_NUM_TYPES,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_JNTFORC_NUM_TYPES
     * parameters: ignore
     */
    BINOUT_JNTFORC_TYPES,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_JNTFORC_NUM_ID
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_NBNDOUT_NUM_TIMESTEP,
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_JNTFORC_NUM_COMPONENT,
     * parameters: idtype: BINOUT_JNTFORC_ID_JOINTS, BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL,
	                      BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_RESULTANT_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_RESULTANT_MOMENT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_JOINTS
     */
    BINOUT_JNTFORC_JOINT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_X_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_Y_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_DISPLACEMENT_Z_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_STIFFNESS_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_DAMPING_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_TOTAL_X,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_STIFFNESS_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_DAMPING_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_TOTAL_Y,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_STIFFNESS_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_DAMPING_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_FORCE_TOTAL_Z,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_TRANSLATIONAL
     */
    BINOUT_JNTFORC_TRANSLATION_JOINT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_THETA_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_THETA_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PSI_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PSI_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_MOMENT_STIFFNESS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_MOMENT_DAMPING,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_THETA_MOMENT_STIFFNESS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_THETA_MOMENT_DAMPING,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_THETA_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PSI_MOMENT_STIFFNESS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PSI_MOMENT_DAMPING,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PSI_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_PHI_THETA_PSI_JOINT_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_GAMMA_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_GAMMA_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_BETA_DEGREES,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_BETA_DEGREES_DT,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_MOMENT_STIFFNESS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_MOMENT_DAMPING,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_GAMMA_SCALE_FACTOR,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_BETA_MOMENT_STIFFNESS,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_BETA_MOMENT_DAMPING,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_BETA_MOMENT_TOTAL,

    /**
     * conversion: double
     * length    : BINOUT_JNTFORC_NUM_TIMESTEP,
     * parameters: id, idtype: BINOUT_JNTFORC_ID_STIFFNESS_GENERALIZED
     */
    BINOUT_JNTFORC_ALPHA_GAMMA_BETA_JOINT_ENERGY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_NUM_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODOUT_SSD_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_NUM_MODE,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_MODE
     * parameters: ignore
     */
    BINOUT_NODOUT_SSD_MODES,

    /**
     * conversion: int
     * length    : 1
     * parameters: datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
	                               BINOUT_DATATYPE_IMAGINARY, BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_NODOUT_SSD_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODOUT_SSD_NUM_COMPONENT
     * parameters: datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
	                               BINOUT_DATATYPE_IMAGINARY, BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_NODOUT_SSD_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_DISP_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_VEL_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_ACCL_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_DISP_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_VEL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_ACCL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_DISP_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_VEL_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_TRANSLATIONAL_ACCL_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_DISP_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_VEL_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_ACCL_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_DISP_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_VEL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_ACCL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_DISP_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_VEL_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, datatype_option: BINOUT_DATATYPE_ALPLITUDE, BINOUT_DATATYPE_PHASEANGLE,
									   BINOUT_DATATYPE_REAL,      BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_NODOUT_SSD_ROTATIONAL_ACCL_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_ROTATIONAL_DISP_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_ROTATIONAL_DISP_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_ROTATIONAL_DISP_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_TRANSLATIONAL_DISP_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_TRANSLATIONAL_DISP_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode, datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTATION
     */
    BINOUT_NODOUT_SSD_MODALCONTRIBUTATION_TRANSLATIONAL_DISP_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_NUM_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODOUT_PSD_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODOUT_PSD_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODOUT_PSD_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_VELOCITY_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_VELOCITY_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_VELOCITY_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_ACCLERATION_X,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_ACCLERATION_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODOUT_PSD_NUM_FREQUENCY
     * parameters: id
     */
    BINOUT_NODOUT_PSD_ACCLERATION_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_SPCM_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODOUT_SPCM_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODOUT_SPCM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODOUT_SPCM_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODOUT_SPCM_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODOUT_SPCM_COMPONENTS,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_DISPLACEMENT_X,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_VELOCITY_X,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_ACCLERATION_X,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_DISPLACEMENT_Y,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_VELOCITY_Y,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_ACCLERATION_Y,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_DISPLACEMENT_Z,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_VELOCITY_Z,

    /**
     * conversion: double
     * length    : 1
     * parameters: id
     */
    BINOUT_NODOUT_SPCM_ACCLERATION_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES , BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL,
     */
    BINOUT_RWFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_RWFORC_NUM_TIMESTEP,
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES , BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL,
     */
    BINOUT_RWFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES , BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,
     */
    BINOUT_RWFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_RWFORC_NUM_ID
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES , BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,
     */
    BINOUT_RWFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: id, idtype = BINOUT_RWFORC_ID_TRANSDUCER
     */
    BINOUT_RWFORC_NUM_NODESET,

    /**
     * conversion: unsigned int
     * length    : BINOUT_RWFORC_NUM_NODESET
     * parameters: id, idtype = BINOUT_RWFORC_ID_TRANSDUCER
     */
    BINOUT_RWFORC_NODESETS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES, BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,,
     */
    BINOUT_RWFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_RWFORC_NUM_COMPONENT
     * parameters: idtype = 	BINOUT_RWFORC_ID_FORCES, BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,,
     */
    BINOUT_RWFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_RWFORC_NUM_TIMESTEP
     * parameters: id, idtype = BINOUT_RWFORC_ID_FORCES
     */
    BINOUT_RWFORC_NORMAL_FORCE,

    /**
     * conversion: double
     * length    : BINOUT_RWFORC_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_RWFORC_ID_FORCES, BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,,
     */
    BINOUT_RWFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_RWFORC_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_RWFORC_ID_FORCES, BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,,
     */
    BINOUT_RWFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_RWFORC_NUM_TIMESTEP
     * parameters: id, idtype = 	BINOUT_RWFORC_ID_FORCES, BINOUT_RWFORC_ID_TRANSDUCER or BINOUT_RWFORC_ID_WALL if BINOUT_RWFORC_ID_WALL param.wallid is needed,,
     */
    BINOUT_RWFORC_FORCE_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_NUM_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODFOR_SSD_NUM_ID
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_NUM_GROUPID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_NODFOR_SSD_NUM_GROUPID
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_GROUP_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_NODFOR_SSD_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_NODFOR_SSD_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_NODE,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_NODE,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_NODE,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_FORCE_Z,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_GROUP,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_TOTAL_X,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_GROUP,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_TOTAL_Y,

    /**
     * conversion: double
     * length    : BINOUT_NODFOR_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_NODFOR_SSD_ID_GROUP,
	              datatype_option = BINOUT_DATATYPE_AMPLITUDE,  BINOUT_DATATYPE_PHASEANGLE,
								    BINOUT_DATATYPE_REAL,       BINOUT_DATATYPE_IMAGINARY,
     */
    BINOUT_NODFOR_SSD_TOTAL_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ELOUTDET_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ELOUTDET_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUTDET_NUM_ID
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ELOUTDET_NUM_COMPONENT
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_COMPONENTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NUM_IPT,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUTDET_NUM_IPT
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_IPTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NUM_NPL,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUTDET_NUM_NPL
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NPLS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NUM_NQT,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUTDET_NUM_NQT
     * parameters: idtype = 	BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG
     */
    BINOUT_ELOUTDET_NQTS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EFFSG,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_EPS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_SIG_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_YIELD,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: datatype_option = BINOUT_DATATYPE_ELOUTDET_INTEGRATION_POINTS or BINOUT_DATATYPE_ELOUTDET_NODAL_POINTS,
	              idtype = BINOUT_ELOUTDET_ID_SOLID,BINOUT_ELOUTDET_ID_SHELL,BINOUT_ELOUTDET_ID_TSHELL or BINOUT_ELOUTDET_ID_NODAVG, 
	              id, ipt, npl, nqt
     */
    BINOUT_ELOUTDET_PLASTIC_STRAIN,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_SIG_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_YIELD,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_SIG_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_YIELD,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_LOWER_EPS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUTDET_NUM_TIMESTEP
     * parameters: idtype=BINOUT_ELOUTDET_ID_NODAVG, id
     */
    BINOUT_ELOUTDET_UPPER_EPS_ZX,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ELOUT_SSD_NUM_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: ignore
     */
    BINOUT_ELOUT_SSD_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
     */
    BINOUT_ELOUT_SSD_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_SSD_NUM_ID
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
     */
    BINOUT_ELOUT_SSD_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
     */
    BINOUT_ELOUT_SSD_NUM_IPT,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_SSD_NUM_IPT
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
     */
    BINOUT_ELOUT_SSD_IPTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ELOUT_SSD_NUM_MODE,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_MODE
     * parameters: ignore
     */
    BINOUT_ELOUT_SSD_MODES,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY, BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ELOUT_SSD_NUM_COMPONENT
     * parameters: idtype: BINOUT_ELOUT_SSD_ID_BEAM,BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,
	                      BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY, BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID,BINOUT_ELOUT_SSD_ID_TSHELL,BINOUT_ELOUT_ID_SHELL
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SOLID
				  datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
								   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_LOWER_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_SHELL, BINOUT_ELOUT_SSD_ID_TSHELL
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                   BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_UPPER_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_AXIAL,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_SHEAR_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_SHEAR_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_MOMENT_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_MOMENT_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_TORSION,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_SIGMA_11,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_SIGMA_12,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_SIGMA_31,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_PLASTIC_EPS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_AMPLITUDE, BINOUT_DATATYPE_PHASEANGLE, BINOUT_DATATYPE_REAL,
				                    BINOUT_DATATYPE_IMAGINARY
     */
    BINOUT_ELOUT_SSD_AXIAL_STRAIN,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, ipt(shell, thickshell), freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_SOLID, BINOUT_ELOUT_SSD_ID_TSHELL, BINOUT_ELOUT_SSD_ID_SHELL
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_AXIAL,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_SHEAR_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_SHEAR_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_MOMENT_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_MOMENT_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_SSD_NUM_FREQUENCY
     * parameters: id, freq_mode,
	              idtype: BINOUT_ELOUT_SSD_ID_BEAM
			      datatype_option: BINOUT_DATATYPE_MODALCONTRIBUTION
     */
    BINOUT_ELOUT_SSD_MODALCONTRIBUTION_TORSION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ELOUT_PSD_NUM_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: ignore
     */
    BINOUT_ELOUT_PSD_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_PSD_NUM_ID
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_NUM_IPT,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_PSD_NUM_IPT
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_IPTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ELOUT_PSD_NUM_COMPONENT
     * parameters: idtype: BINOUT_ELOUT_PSD_ID_BEAM, BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL,
	                      BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_PSD_ID_SOLID, BINOUT_ELOUT_PSD_ID_TSHELL, BINOUT_ELOUT_PSD_ID_SHELL
     */
    BINOUT_ELOUT_PSD_STRESS_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SOLID
     */
    BINOUT_ELOUT_PSD_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_LOWER_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_XX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_YY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_ZZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_XY,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_YZ,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_SHELL, BINOUT_ELOUT_PSD_ID_TSHELL
     */
    BINOUT_ELOUT_PSD_UPPER_STRAIN_ZX,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_AXIAL,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_SHEAR_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_SHEAR_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_MOMENT_S,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_MOMENT_T,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_TORSION,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_SIGMA_11,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_SIGMA_12,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_SIGMA_31,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_PLASTIC_EPS,

    /**
     * conversion: double
     * length    : BINOUT_ELOUT_PSD_NUM_FREQUENCY
     * parameters: id, idtype: BINOUT_ELOUT_PSD_ID_BEAM
     */
    BINOUT_ELOUT_PSD_AXIAL_STRAIN,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ELOUT_SPCM_NUM_ID
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_NUM_IPT,

    /**
     * conversion: int
     * length    : BINOUT_ELOUT_SPCM_NUM_IPT
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_IPTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ELOUT_SPCM_NUM_COMPONENT
     * parameters: idtype: BINOUT_ELOUT_SPCM_ID_BEAM, BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_TSHELL,
	                      BINOUT_ELOUT_SPCM_ID_SHELL
     */
    BINOUT_ELOUT_SPCM_COMPONENTS,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_XX,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_YY,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_ZZ,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_XY,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_YZ,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(shell,thickshell),
	              idtype: BINOUT_ELOUT_SPCM_ID_SOLID, BINOUT_ELOUT_SPCM_ID_SHELL, BINOUT_ELOUT_SPCM_ID_TSHELL
     */
    BINOUT_ELOUT_SPCM_STRESS_ZX,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_AXIAL,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_SHEAR_S,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_SHEAR_T,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_MOMENT_S,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_MOMENT_T,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_TORSION,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(beam), idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_SIGMA_11,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(beam), idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_SIGMA_12,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(beam), idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_SIGMA_31,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(beam), idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_PLASTIC_EPS,

    /**
     * conversion: double
     * length    : 1
     * parameters: id, ipt(beam), idtype: BINOUT_ELOUT_SPCM_ID_BEAM
     */
    BINOUT_ELOUT_SPCM_AXIAL_STRAIN,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RBDOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_RBDOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RBDOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_RBDOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_RBDOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_RBDOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_RBDOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_RBDOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_11,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_12,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_13,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_21,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_22,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_23,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_31,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_32,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_DIRCOS_33,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_AX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_AY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_AZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_DX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_DY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_DZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RAX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RAY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RAZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RDX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RDY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RDZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RVX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RVY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_RVZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_VX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_VY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_VZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_X,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_Y,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_GLOBAL_Z,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_AX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_AY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_AZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_DX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_DY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_DZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RAX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RAY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RAZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RDX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RDY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RDZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RVX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RVY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_RVZ,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_VX,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_VY,

    /**
     * conversion: double
     * length    : BINOUT_RBDOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_RBDOUT_LOCAL_VZ,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SLEOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SLEOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SLEOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SLEOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_SLEOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SLEOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SLEOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SLEOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SLEOUT_FRICTION_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SLEOUT_MASTER,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SLEOUT_SLAVE,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SLEOUT_SLAVEMASTER,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SLEOUT_TOTAL_ENERGY,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SLEOUT_TOTAL_FRICTION,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SLEOUT_TOTAL_MASTER,

    /**
     * conversion: double
     * length    : BINOUT_SLEOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SLEOUT_TOTAL_SLAVE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPCFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_FORCEID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPCFORC_NUM_FORCEID
     * parameters: ignore
     */
    BINOUT_SPCFORC_FORCE_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_FORCESETID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPCFORC_NUM_FORCESETID
     * parameters: ignore
     */
    BINOUT_SPCFORC_FORCESET_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SPCFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SPCFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = force_id
     */
    BINOUT_SPCFORC_FORCE_X,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = force_id
     */
    BINOUT_SPCFORC_FORCE_Y,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = force_id
     */
    BINOUT_SPCFORC_FORCE_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_MOMENTID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPCFORC_NUM_MOMENTID
     * parameters: ignore
     */
    BINOUT_SPCFORC_MOMENT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPCFORC_NUM_MOMENTSETID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPCFORC_NUM_MOMENTSETID
     * parameters: ignore
     */
    BINOUT_SPCFORC_MOMENTSET_IDS,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = moment_id
     */
    BINOUT_SPCFORC_MOMENT_X,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = moment_id
     */
    BINOUT_SPCFORC_MOMENT_Y,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: id = moment_id
     */
    BINOUT_SPCFORC_MOMENT_Z,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPCFORC_RESULTANT_X,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPCFORC_RESULTANT_Y,

    /**
     * conversion: double
     * length    : BINOUT_SPCFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SPCFORC_RESULTANT_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SWFORC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_SWFORC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SWFORC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SWFORC_NUM_ID
     * parameters: ignore
     */
    BINOUT_SWFORC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SWFORC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_SWFORC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_SWFORC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_AXIAL,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_FAILURE,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_LENGTH,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_RESULTANT_MOMENT,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_SHEAR,

    /**
     * conversion: double
     * length    : BINOUT_SWFORC_NUM_TIMESTEP
     * parameters: id,  idtype: BINOUT_SWFORC_ID_CONSTRAINT, BINOUT_SWFORC_ID_WELD, BINOUT_SWFORC_ID_BEAM, BINOUT_SWFORC_ID_SOLID,
	                           BINOUT_SWFORC_ID_NONNODAL_CONSTRAINT, BINOUT_SWFORC_ID_SOLID_ASSEMBLY
     */
    BINOUT_SWFORC_TORSION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CURVOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_CURVOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_CURVOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CURVOUT_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_CURVOUT_NUM_ID
     * parameters: ignore
     */
    BINOUT_CURVOUT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_CURVOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_CURVOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_CURVOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_CURVOUT_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_CURVOUT_VALUES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBSENSOR_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DBSENSOR_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBSENSOR_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DBSENSOR_NUM_ID
     * parameters: ignore
     */
    BINOUT_DBSENSOR_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBSENSOR_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DBSENSOR_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DBSENSOR_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_SOLID_ID,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_TEMPERATURE,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_POSITION_X,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_POSITION_Y,

    /**
     * conversion: double
     * length    : BINOUT_DBSENSOR_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBSENSOR_POSITION_Z,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBBEMAC_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_DBBEMAC_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_DBBEMAC_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBBEMAC_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_DBBEMAC_NUM_ID
     * parameters: ignore
     */
    BINOUT_DBBEMAC_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_DBBEMAC_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_DBBEMAC_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_DBBEMAC_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_DBBEMAC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBBEMAC_FREQUENCY,

    /**
     * conversion: double
     * length    : BINOUT_DBBEMAC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBBEMAC_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_DBBEMAC_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_DBBEMAC_SOUNDPRESSURELEVEL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ICVOUT_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_ICVOUT_NUM_TIMESTEP
     * parameters: ignore
     */
    BINOUT_ICVOUT_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ICVOUT_NUM_ICVIID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ICVOUT_NUM_ICVIID
     * parameters: ignore
     */
    BINOUT_ICVOUT_ICVIIDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ICVOUT_NUM_ICVID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_ICVOUT_NUM_ICVID
     * parameters: ignore
     */
    BINOUT_ICVOUT_ICVIDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_ICVOUT_NUM_COMPONENT,

    /**
     * conversion: _BINOUT_String
     * length    : BINOUT_ICVOUT_NUM_COMPONENT
     * parameters: ignore
     */
    BINOUT_ICVOUT_COMPONENTS,

    /**
     * conversion: double
     * length    : BINOUT_ICVOUT_NUM_TIMESTEP
     * parameters: icvi id
     */
    BINOUT_ICVOUT_ICVI_AREA,

    /**
     * conversion: double
     * length    : BINOUT_ICVOUT_NUM_TIMESTEP
     * parameters: icvi id
     */
    BINOUT_ICVOUT_ICVI_FLOW_RATE,

    /**
     * conversion: double
     * length    : BINOUT_ICVOUT_NUM_TIMESTEP
     * parameters: icv id
     */
    BINOUT_ICVOUT_ICV_PRESSURE,

    /**
     * conversion: double
     * length    : BINOUT_ICVOUT_NUM_TIMESTEP
     * parameters: icv id
     */
    BINOUT_ICVOUT_ICV_VOLUME,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHVICINITY_NUM_TIMESTEP,

    /**
     * conversion: double
     * length    : BINOUT_SPHVICINITY_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHVICINITY_X,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BINOUT_SPHVICINITY_NUM_ID,

    /**
     * conversion: unsigned int
     * length    : BINOUT_SPHVICINITY_NUM_ID
     * parameters: ignore
     */
    BINOUT_SPHVICINITY_IDS,

    /**
     * conversion: double
     * length    : BINOUT_SPHVICINITY_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHVICINITY_COUNT,

    /**
     * conversion: double
     * length    : BINOUT_SPHVICINITY_NUM_TIMESTEP
     * parameters: id
     */
    BINOUT_SPHVICINITY_TOTALMASS,

};

#endif

typedef struct _BINOUT_Parameter_
{
    /**
    * the entity id, default is 0
    */
    int id;
    /**
    * the number through thickness integration point,  default is 1
    */
    int ipt;
    /**
   * the node id  of element, for the eloutdet branch only,  default is 0
   */
    int nqt;
    /**
    *  the number of  in-plane integration point,  default is 1
    */
    int npl;
    /**
    * the nth order mode,  default is 1
    */
    int freq_mode;
    /**
    * the contact id for ncforc, default is 0
    */
    int cid;
    /**
    * the nodeset id for rwforc, and default is 0
    */
    int nodeset;
    /**
     * the number of history variable, and default is 1
    */
    int ihv;
	/**
	 * the wallid id for rwforc, and default is 1
	*/
	int wallid;
	/**
    * the partid id for abstat_cpm, and default is 0
    */
    int partid;
    /**
    * the speciesid id for abstat_cpm, and default is 1, air is 0
    */
    int speciesid;
	/*
    * state index default is 0
    */
    int stateindex;
	/**
	* the type of entity id
	*/
	enum BINOUT_IdType idtype;
	/**
    * the option value for BINOUT_DataType
    */
	enum BINOUT_DataTypeOption datatype_option;
}_BINOUT_Parameter;

typedef struct _BINOUT_String_
{
	char string[64];
}_BINOUT_String;

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus
	
	CREADERAPI char*  Binout_Open(const char* filename);
	CREADERAPI void   Binout_Close(char* handle);

    CREADERAPI const char* Get_LSReaderVersion();

	// Recommended API
	CREADERAPI void  Binout_Init(_BINOUT_Parameter* param);
	CREADERAPI int   Binout_Read(char* handle, enum BINOUT_DataType type, char* value, _BINOUT_Parameter param);

	// Old API
	CREADERAPI int    Binout_GetNumberOfBranch(char* handle, size_t* max);
	CREADERAPI int    Binout_GetBranch(char* handle, char* branches[]);
	CREADERAPI int    Binout_GetNumberOfComponent(char* handle, size_t* max);
	CREADERAPI int    Binout_GetComponent(char* handle, char* components[]);
	CREADERAPI int    Binout_GetNumberOfXArray(char* handle);
	CREADERAPI int    Binout_GetXArray(char* handle, double* xArray);
	CREADERAPI int    Binout_GetNumberOfYArray(char* handle);
	CREADERAPI int    Binout_GetYArray(char* handle, double* yArray);
	CREADERAPI int    Binout_GetNumberOfId(char* handle);
	CREADERAPI int    Binout_GetId(char* handle, unsigned int* id);
	CREADERAPI int    Binout_SetBranch(const char* handle, const char* branch);
	CREADERAPI int    Binout_SetStrId(const char* handle, const char* id);
	CREADERAPI int    Binout_SetId(const char* handle, unsigned int id);
	CREADERAPI int    Binout_SetIdMasterSlave(const char* handle, unsigned int id, int master);
	CREADERAPI int    Binout_SetComponent(const char* handle, const char* comp);
	CREADERAPI int    Binout_IsValid(const char* filename);
	CREADERAPI int    Binout_Write(const char* filename, double* x_array, double* y_array, int size);
	CREADERAPI int    Binout_SetIdIndex(const char* handle, unsigned int idindex);
	CREADERAPI int    Binout_SetIdLabel(const char* handle, const char* idlabel);
	CREADERAPI int    Binout_GetNumberofIdLabels(const char* handle, size_t* max);
	CREADERAPI int    Binout_GetIdLabels(char* handle, char* Idlabels[]);
	CREADERAPI int    Binout_GetNumberOfIpt(char* handle);
	CREADERAPI int    Binout_GetIpt(char* handle, unsigned int* ipt);
	CREADERAPI int    Binout_SetIpt(const char* handle, unsigned int ipt);
	CREADERAPI int    Binout_GetNumberOfNpl(char* handle);
	CREADERAPI int    Binout_GetNpl(char* handle, unsigned int* npl);
	CREADERAPI int    Binout_SetNpl(const char* handle, unsigned int npl);
	CREADERAPI int    Binout_GetNumberOfNqt(char* handle);
	CREADERAPI int    Binout_GetNqt(char* handle, unsigned int* nqt);
	CREADERAPI int    Binout_SetNqt(const char* handle, unsigned int nqt);
    CREADERAPI int    Binout_SetLegend(const char* handle, const char* name);
    CREADERAPI int    Binout_GetNumberOfLegend(char* handle);
    CREADERAPI int    Binout_GetLegend(const char* handle, unsigned int* legendids, char* legendnames[]);
#ifdef __cplusplus
}
#endif // __cplusplus

#endif // !__BINOUT_READER_WRAPPER_C_H__

        