#include <string.h>
#include <iostream>
#include <vector>

#include "../config.h"
#include "d3plotreader.h"
#include "binoutreader.h"
using namespace std;

int main()
{
	{
		//======================D3plotReader======================
		string d3plot_file = "D:\\lsreader\\lsreader\\test\\lsreader_cxx_test\\data\\d3max\\flag\\d3max";

#ifdef WIN32
		string::size_type pos = d3plot_file.find('/');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "\\");
			pos = d3plot_file.find('/');
		}
#else
		string::size_type pos = d3plot_file.find('\\');
		while (pos != string::npos)
		{
			d3plot_file.replace(pos, 1, "/");
			pos = d3plot_file.find('\\');
		}
#endif

		D3plotReader dr(d3plot_file.c_str());

		bool hasStress = dr.GetDataBool(D3P_HAS_SOLID_STRESS);

		D3P_Parameter dp;
		dp.ist = 0;
		std::vector<D3P_Tensor> solidStress = dr.GetDataTensorArray(D3P_SOLID_STRESS, dp);

	}


#ifdef WIN32
	system("pause");
#endif
}
