#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "../config.h"
#include "d3plotreaderc.h"
#include "binoutreaderc.h"
static int test_femzip()
{
	int success = 0;
	char femzip_file[1024];
	int i = 0;
	char* handle;
	int num_shell = 0;
	int num_state = 0;
	int num_nodes = 0;
	int* nodal_ids = NULL;
	int* shell_ids = NULL;
	int internal_id = -1;
	_D3P_Control control;
	_D3P_Parameter dp;
	_D3P_Shell* shell_conn = NULL;
	_D3P_Tensor* shell_stress = NULL;
	D3P_ReturnType ret;
	D3P_Init(&dp);
	strcpy(femzip_file, DATA_PATH_FEMZIP);
	handle = D3P_Open(femzip_file);
	ret = D3P_OpenState(handle);
	if (ret != D3P_SUCCESS)
		return success;
	if (!handle)
		goto cleanup;
	if (!D3P_Read(handle, D3P_CONTROL, (char*)&control, dp))
		goto cleanup;

	if (!D3P_Read(handle, D3P_NUM_SHELL, (char*)&num_shell, dp))
		goto cleanup;
	printf("num_shell: %d\n", num_shell);

	if (!D3P_Read(handle, D3P_NUM_STATES, (char*)&num_state, dp))
		goto cleanup;
	printf("num_state: %d\n", num_state);

	if (!D3P_Read(handle, D3P_NUM_NODES, (char*)&num_nodes, dp))
		goto cleanup;
	printf("num_nodes: %d\n", num_nodes);

	nodal_ids = (int*)malloc(num_nodes * sizeof(int));
	if (!D3P_Read(handle, D3P_NODE_IDS, (char*)nodal_ids, dp))
		goto cleanup;

	shell_ids = (int*)malloc(num_shell * sizeof(int));
	if (!D3P_Read(handle, D3P_SHELL_IDS, (char*)shell_ids, dp))
		goto cleanup;

	dp.iuser = 3;
	if (!D3P_Read(handle, D3P_SHELL_INTERNAL_ID, (char*)&internal_id, dp))
		goto cleanup;
	printf("internal_id: %d\n", internal_id);

	shell_conn = (_D3P_Shell*)malloc(num_shell * sizeof(_D3P_Shell));
	if (!D3P_Read(handle, D3P_SHELL_CONNECTIVITY_MAT, (char*)shell_conn, dp))
		goto cleanup;
	printf("shell_conn[0](%d, %d, %d, %d)\n", nodal_ids[shell_conn[0].conn[0] - 1], nodal_ids[shell_conn[0].conn[1] - 1], nodal_ids[shell_conn[0].conn[2] - 1], nodal_ids[shell_conn[0].conn[3] - 1]);

	dp.ist = 24;
	dp.ipt = 2;
	shell_stress = (_D3P_Tensor*)malloc(num_shell * sizeof(_D3P_Tensor));
	if (!shell_stress)
		goto cleanup;
	if (!D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress, dp))
		goto cleanup;
	printf("shell_stress[0](%f, %f, %f, %f, %f, %f)\n", shell_stress[0].t[0], shell_stress[0].t[1], shell_stress[0].t[2], shell_stress[0].t[3], shell_stress[0].t[4], shell_stress[0].t[5]);

	free(shell_conn); shell_conn = NULL;
	free(nodal_ids); nodal_ids = NULL;
	free(shell_ids); shell_ids = NULL;
	free(shell_stress); shell_stress = NULL;

	success = 1;
cleanup:
	if (nodal_ids)
		free(nodal_ids); nodal_ids = NULL;
	if (shell_ids)
		free(shell_ids); shell_ids = NULL;
	if (shell_conn)
		free(shell_conn); shell_conn = NULL;
	if (shell_stress)
		free(shell_stress); shell_stress = NULL;
	if (handle)
		D3P_Close(handle);

	return success;
}

static int test_des()
{
	int success = 0;
	char des_file[1024];
	_D3P_Parameter dp;
	char* handle = NULL;
	int has_des = 0;
	int num_des_elem_in_geom = 0;
	int num_des_elem_in_state = 0;
	int num_des_elem_var_in_state = 0;
	_D3P_Var* des_elem_var_list_in_state = NULL;
	_D3P_Des* des_nodal_mat_radius_mass_inertia = NULL;
	int* var_int = NULL;
	float* var_float = NULL;
	int i = 0, j = 0;
	char* name = NULL;
	int type = 0;
	int id = 0;
	int internal_id = 0;
	int mat = 0;
	float radius = 0.0f;
	float mass = 0.0f;
	float inertia = 0.0f;
	int num_state = 0;
	_D3P_Vector* coordinate = NULL;
	int num_nodes = 0;
	_D3P_Vector coord;

	D3P_Init(&dp);
	strcpy(des_file, DATA_PATH_DES);

#ifdef WIN32		
	for (i = 0; i < strlen(des_file); i++) {
		if (des_file[i] == '/') {
			des_file[i] = '\\';
		}
	}
#else
	for (i = 0; i < strlen(des_file); i++) {
		if (des_file[i] == '\\') {
			des_file[i] = '/';
		}
	}
#endif

	handle = D3P_Open(des_file);
	D3P_SetMessageLevel(handle, D3P_MESSAGE_VERBOSE);

	do {
		D3P_Read(handle, D3P_HAS_DES_DATA, (char*)&has_des, dp);
		if (!has_des)
			break;

		D3P_Read(handle, D3P_NUM_STATES, (char*)&num_state, dp);

		//! Actually, for all des model, ides should always be 0. It's okay if we don't specify ides=0
		D3P_Read(handle, D3P_NUM_DES_ELEM_IN_GEOM, (char*)&num_des_elem_in_geom, dp);
		D3P_Read(handle, D3P_NUM_DES_ELEM_IN_STATE, (char*)&num_des_elem_in_state, dp);
		D3P_Read(handle, D3P_NUM_DES_ELEM_VAR_IN_STATE, (char*)&num_des_elem_var_in_state, dp);
		des_elem_var_list_in_state = (_D3P_Var*)malloc(num_des_elem_var_in_state * sizeof(_D3P_Var));
		des_nodal_mat_radius_mass_inertia = (_D3P_Des*)malloc(num_des_elem_in_geom * sizeof(_D3P_Des));
		D3P_Read(handle, D3P_DES_ELEM_VAR_LIST_IN_STATE, (char*)des_elem_var_list_in_state, dp);
		D3P_Read(handle, D3P_DES_NODAL_MAT_RADIUS_MASS_INERTIA, (char*)des_nodal_mat_radius_mass_inertia, dp);

		D3P_Read(handle, D3P_NUM_NODES, (char*)&num_nodes, dp);
		coordinate = (_D3P_Vector*)malloc(num_nodes * sizeof(_D3P_Vector));
		D3P_Read(handle, D3P_NODE_INITIAL_COORDINATES, (char*)coordinate, dp);

		//! for geometry block, there are:
		//!    word #1: Element ID
		//!	   word #2: Part ID
		//!	   word #3: Radius
		//!	   word #4: Mass
		//!	   word #5: Inertia
		//!	   word #6: number of words for reserved for a DE element(NGEVi)
		//!	   word #7 - NGEVi + 6: Reserved for a DE element
		for (i = 0; i < num_des_elem_in_geom; i++) {
			id = des_nodal_mat_radius_mass_inertia[i].id;
			//! the id is nodal id, we can use it to get the coordinate and other variables...
			dp.iuser = id;
			D3P_Read(handle, D3P_NODE_INTERNAL_ID, (char*)&internal_id, dp);
			dp.iuser = -1;
			coord = coordinate[internal_id];

			mat = des_nodal_mat_radius_mass_inertia[i].mat;
			radius = des_nodal_mat_radius_mass_inertia[i].radius;
			mass = des_nodal_mat_radius_mass_inertia[i].mass;
			inertia = des_nodal_mat_radius_mass_inertia[i].inertia;
			/* do something using element geometry block, such as building the map of part and element...*/
		}

		//! for state block, there are:
		//!    The first variables should be always in the database
		//!	   word # 1 : flag, > 0 active, <= 0 inactive
		//!	   ...
		//!	   Word # NSEV:

		//! the first variable is always active flag.
		//! For element, it may be active or inactive for each state.
		//! So we can use the flag to check if the element is active for the current state
		for (i = 0; i < num_state; i++) {
			dp.var_name = "Active DES";
			dp.ist = i;
			var_int = (int*)malloc(num_des_elem_in_state * sizeof(int));
			D3P_Read(handle, D3P_DES_DATA_IN_STATE, (char*)var_int, dp);
			for (j = 0; j < num_des_elem_in_state; j++) {
				if (var_int != 0) {
					/* active for current state*/
				}
				else {
					/* inactive for current state*/
				}
			}
		}

		for (i = 1; i < num_des_elem_var_in_state; i++) {
			name = des_elem_var_list_in_state[i].name;
			type = des_elem_var_list_in_state[i].type;

			dp.var_name = name;
			dp.ist = 0;
			//! int
			if (type == 1) {
				var_int = (int*)malloc(num_des_elem_in_state * sizeof(int));
				D3P_Read(handle, D3P_DES_DATA_IN_STATE, (char*)var_int, dp);
				/*do something using var_int...*/
			}
			//! float
			else if (type == 2) {
				var_float = (float*)malloc(num_des_elem_in_state * sizeof(float));
				D3P_Read(handle, D3P_DES_DATA_IN_STATE, (char*)var_float, dp);
				/*do something using var_float...*/
			}
		}

	} while (0);

	if (handle)
		D3P_Close(handle);
	if (des_elem_var_list_in_state)
		free(des_elem_var_list_in_state);
	if (des_nodal_mat_radius_mass_inertia)
		free(des_nodal_mat_radius_mass_inertia);
	if (var_int)
		free(var_int);
	if (var_float)
		free(var_float);
	if (coordinate)
		free(coordinate);
}

int main()
{
	
    unsigned int i = 0;
    char d3plot_file[1024];
	char title[80];
	char* handle = NULL;
    int ns = 0, nn = 0, nsh = 0;
    int* nodal_ids = NULL;
    _D3P_Vector* coords = NULL;
    _D3P_VectorDouble* dcoords = NULL;
    _D3P_Shell* shell_conn = NULL;
    _D3P_Tensor * shell_stress = NULL;
	float* shell_history_var = NULL;
	_D3P_Tensor* shell_stress_bypart = NULL;
    _D3P_Parameter dp;
	size_t size = 0;
    
	char binout_files[1024];
	char out_path[1024];
	char* handle_binout = NULL;
	char** branches = NULL;
	size_t max_branch = 0;
	unsigned int num_branch = 0;
	unsigned int num_id = 0;
	unsigned int num_array = 0;
	double* x_array = NULL;
	double* y_array = NULL;
	unsigned int* ids = NULL;
	
	//======================D3plotReader======================
	D3P_Init(&dp);
    strcpy(d3plot_file, DATA_PATH_D3P);
    
#ifdef WIN32		
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '/') {
            d3plot_file[i] = '\\';
        }
    }
#else
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '\\') {
            d3plot_file[i] = '/';
        }
    }
#endif
    
	handle = D3P_Open(d3plot_file);
	if (!handle)
		goto cleanup;
	
	D3P_Read(handle, D3P_TITLE, (char*)title, dp);
	i = 0;
	printf("title: ");
	for(i=0;i<strlen(title);i++)
	{
		printf("%c", title[i]);
	}
	printf("\n");

    D3P_Read(handle, D3P_NUM_STATES, (char*)&ns, dp);
    printf("num states: %d\n", ns);

    
    D3P_Read(handle, D3P_NUM_NODES, (char*)&nn, dp);
    printf("num nodes: %d\n", nn);

	size = nn * sizeof(int);
	nodal_ids = (int*)malloc(size);
	D3P_Read(handle, D3P_NODE_IDS, (char*)nodal_ids, dp);

    D3P_Read(handle, D3P_NUM_SHELL, (char*)&nsh, dp);
    printf("num shells: %d\n", nsh);

	size = nsh * sizeof(_D3P_Shell);
	shell_conn = (_D3P_Shell*)malloc(size);
	D3P_Read(handle, D3P_SHELL_CONNECTIVITY_MAT, (char*)shell_conn, dp);
	if (!size || !shell_conn || !nodal_ids)
		goto cleanup;
	printf("shell_conn[0](%d, %d, %d, %d)\n", nodal_ids[shell_conn[0].conn[0]-1], nodal_ids[shell_conn[0].conn[1]-1], nodal_ids[shell_conn[0].conn[2]-1], nodal_ids[shell_conn[0].conn[3]-1]);

	size = nn * sizeof(_D3P_Vector);
    coords = (_D3P_Vector*) malloc (size);
    dp.ist = 0;
    D3P_Read(handle, D3P_NODE_COORDINATES, (char*)coords, dp);
	if (!size || !coords)
		goto cleanup;
	printf("coords[211](%f, %f, %f) at the first state\n", coords[nn-1].v[0], coords[nn-1].v[1], coords[nn-1].v[2]);

    dp.ist = 11;
    D3P_Read(handle, D3P_NODE_COORDINATES, (char*)coords, dp);
	printf("coords[211](%.10f, %.10f, %.10f) at the last state\n", coords[nn-1].v[0], coords[nn-1].v[1], coords[nn-1].v[2]);
    

	size = nn * sizeof(_D3P_VectorDouble);
	dcoords = (_D3P_VectorDouble*)malloc(size);
    D3P_Read(handle, D3P_NODE_COORDINATES_DOUBLE, (char*)dcoords, dp);
	if (!size || !dcoords)
		goto cleanup;
	printf("coords[211](%.10f, %.10f, %.10f) at the last state\n", dcoords[nn-1].v[0], dcoords[nn-1].v[1], dcoords[nn-1].v[2]);

    dp.ipt = 2;
	size = nsh * sizeof(_D3P_Tensor);
	shell_stress = (_D3P_Tensor*)malloc(size);
	D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress, dp);
	if (!size || !shell_stress)
		goto cleanup;
	printf("shell_stress[0](%f, %f, %f, %f, %f, %f)\n", shell_stress[0].t[0], shell_stress[0].t[1], shell_stress[0].t[2], shell_stress[0].t[3], shell_stress[0].t[4], shell_stress[0].t[5]);
	

	dp.ist = 0;
	dp.ipt = 0;
	dp.ihv = 1;
	size = nsh * sizeof(float);
	shell_history_var = (float*)malloc(size);
	D3P_Read(handle, D3P_SHELL_HISTORY_VAR, (char*)shell_history_var,dp);
	if (!size || !shell_history_var)
		goto cleanup;
	printf("shell_history_var[0]: %f\n", shell_history_var[0]);

	D3P_Init(&dp);
	dp.ipart_user = 1;
	D3P_Read(handle, D3P_NUM_SHELL, (char*)&nsh, dp);
	printf("ipart_user=1, num:%d\n", nsh);

	shell_stress_bypart = (_D3P_Tensor*)malloc(nsh * sizeof(_D3P_Tensor));
	dp.ist = 5;
	dp.ipt = 0;
	dp.ipart_user = 1;
	D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress_bypart, dp);
	printf("ipart_user=1, shell_stress[10].t[0]: %f", shell_stress_bypart[10].t[0]);
	

    D3P_Close(handle);

cleanup:
	if(shell_conn)
		free(shell_conn);
	if(nodal_ids)
		free(nodal_ids);
	if(coords)
		free(coords);
	if(shell_stress)
		free(shell_stress);
	if(shell_history_var)
		free(shell_history_var);
	if (shell_stress_bypart)
		free(shell_stress_bypart);

	//======================BinoutReader======================
	strcpy(binout_files, DATA_PATH_BINOUT);

#ifdef WIN32		
	for (i = 0; i < strlen(binout_files); i++) {
		if (binout_files[i] == '/') {
			binout_files[i] = '\\';
		}
	}
#else
	for (i = 0; i < strlen(binout_files); i++) {
		if (binout_files[i] == '\\') {
			binout_files[i] = '/';
		}
	}
#endif

	strcpy(out_path, OUTPUT_PATH_C);

#ifdef WIN32		
	for (i = 0; i < strlen(out_path); i++) {
		if (out_path[i] == '/') {
			out_path[i] = '\\';
		}
	}
#else
	for (i = 0; i < strlen(out_path); i++) {
		if (out_path[i] == '\\') {
			out_path[i] = '/';
		}
	}
#endif

	printf("%d\n", Binout_IsValid(binout_files));

	handle_binout = Binout_Open(binout_files);

	if (!handle_binout)
		goto cleanup_binout;

	num_branch = Binout_GetNumberOfBranch(handle_binout, &max_branch);
	if (!num_branch)
		goto cleanup_binout;
	branches = (char**)calloc(num_branch, sizeof(char*));
	if (!branches)
		goto cleanup_binout;
	for (i = 0; i < num_branch; i++)
	{
		branches[i] = (char*)malloc(max_branch);
		if (branches[i])
			memset(branches[i], 0, max_branch);
		else
			goto cleanup_binout;
		
	}
	if (!Binout_GetBranch(handle_binout, branches))
		goto cleanup_binout;
	printf("Branches: \n");
	for (i = 0; i < num_branch; i++)
	{
		printf("%s,", branches[i]);
	}
	printf("\n");

	Binout_SetBranch(handle_binout, "nodout");
	num_id = Binout_GetNumberOfId(handle_binout);

	if (!num_id)
		goto cleanup_binout;
	ids = (unsigned int*)malloc(sizeof(unsigned int) * num_id);
	if (!ids)
		goto cleanup_binout;
	memset(ids, 0, sizeof(unsigned int) * num_id);
	
	if (!Binout_GetId(handle_binout, ids))
		goto cleanup_binout;
	printf("ids:\n");
	for (i = 0; i < num_id; i++)
	{
		printf("%d,", ids[i]);
	}
	printf("\n");

	Binout_SetId(handle_binout, 1787);
	Binout_SetComponent(handle_binout, "x_acceleration");

	num_array = Binout_GetNumberOfXArray(handle_binout);
	if (!num_array)
		goto cleanup_binout;
	x_array = (double*)malloc(sizeof(double) * num_array);
	y_array = (double*)malloc(sizeof(double) * num_array);
	if (!x_array || !y_array)
		goto cleanup_binout;
	memset(x_array, 0, sizeof(double) * num_array);
	memset(y_array, 0, sizeof(double) * num_array);

	Binout_GetXArray(handle_binout, x_array);
	Binout_GetYArray(handle_binout, y_array);

	Binout_Write(out_path, x_array, y_array, num_array);

cleanup_binout:
	if (handle_binout)
	{
		Binout_Close(handle_binout);
		handle_binout = NULL;
	}	
	if (branches)
	{
		for (i = 0; i < num_branch; i++)
		{
			if (branches[i])
			{
				free(branches[i]);
				branches[i] = NULL;
			}
		}
		free(branches);
		branches = NULL;
	}
	if (x_array)
	{
		free(x_array);
		x_array = NULL;
	}
	if (y_array)
	{
		free(y_array);
		y_array = NULL;
	}

	test_femzip();
	test_des();

#ifdef WIN32
	system("pause");
#endif
}
