#ifndef __IGAPOST_READER_WRAPPER_C_H__
#define __IGAPOST_READER_WRAPPER_C_H__

#ifdef WIN32
#if defined (LSREADER_C_STATIC_LIB)
#define CREADERAPI
#else
#if defined (lsreader_c_EXPORTS)
#define CREADERAPI __declspec(dllexport)
#else // outside DLL
#define CREADERAPI __declspec(dllimport)
#endif
#endif

#else
#define CREADERAPI
#endif

#include <stddef.h>

//__IGAPOST_DATA_TYPE_H__
#ifndef __IGAPOST_DATA_TYPE_ENUMERATIONS__
#define __IGAPOST_DATA_TYPE_ENUMERATIONS__

enum IGAPost_DataType
{
	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_1D_BREP,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_1D_NURBS_UVW,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_1D_NURBS_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_BASIS_TRANSFORM_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_BEZIER_XYZ, /*v1.0 only*/

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_2D_BREP,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_2D_NURBS_UVW,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_2D_NURBS_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_ELEMENT,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_3D_NURBS_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_POINT_UVW,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_EDGE_UVW,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_EDGE_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_FACE_UVW,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_FACE_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_SHELL,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_VOLUME_XYZ,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_SOLID,

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_NUM_STATE,

	/**
	* conversion: char
	* length    : 12
	* parameters: ignore
	*/
	IGAPOST_DATE,

	/**
	* conversion: char
	* length    : 12
	* parameters: ignore
	*/
	IGAPOST_REVISION,

	/**
	* conversion: char
	* length    : 80
	* parameters: ignore
	*/
	IGAPOST_TITLE,

	/**
	* conversion: char
	* length    : 12
	* parameters: ignore
	*/
	IGAPOST_VERSION, //hyb/mpp/smp s/d RXX/DEV, LSDA_I1 integer

	/**
	* conversion: char
	* length    : 20
	* parameters: ignore
	*/
	IGAPOST_ODB_VERSION, // IGA binary output database version, LSDA_I1 integer

	/**
	* conversion: double
	* length    : IGAPOST_NUM_STATE
	* parameters: ignore
	*/
	IGAPOST_TIMES, //simulation time at each plot state, real vector of length nstate, 

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_AUX_NUM_BREP_ID, //number of boundary representation IDs

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_AUX_NUM_EDGE_ID, // number of parametric edge IDs

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_AUX_NUM_LOCAL_ELEM_ID, // number of local element IDs

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_AUX_NUM_FACE_ID, // number of local element IDs

	/**
	* conversion: int
	* length    : 1
	* parameters: ignore
	*/
	IGAPOST_AUX_NUM_ACTIVE_CONTROL_PNTS, //number of active control points

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_1D_BREP
	*/
	IGAPOST_1D_BREP_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_BREP
	*/
	IGAPOST_1D_BREP_ID,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_BREP
	*/
	IGAPOST_1D_BREP_NUM_PARM_EDGE_ID,

	/**
	* conversion: int
	* length    : IGAPOST_1D_BREP_NUM_PARM_EDGE_ID
	* parameters: index base from 0 to IGAPOST_NUM_1D_BREP
	*/
	IGAPOST_1D_BREP_PARM_EDGE_ID,

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_PATCH_ID, // parametric univariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_NUM_CTRL_PNTS, // number of control points in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_DEGREE, //polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_KNOT_VECTOR_TYPE, // knot vector type in the local r - direction(optional, default unir = 0)

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_UVW_NUM_CTRL_PNTS_R + IGAPOST_1D_NURBS_UVW_DEGREE_R + 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW,
	*/
	IGAPOST_1D_NURBS_UVW_KNOT_VECTOR, // knot vector in the local r - direction(iff unir = 0),  real vector of length nr + pr + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW,
	*/
	IGAPOST_1D_NURBS_UVW_KNOT_FIRST, // first knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW,
	*/
	IGAPOST_1D_NURBS_UVW_KNOT_LAST, // last knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_NUM_DIM, // number of parametric dimensions the NURBS is embedded in

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_UVW_NUM_DIM * IGAPOST_1D_NURBS_UVW_NUM_CTRL_PNTS_R
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_CTRL_PNT_COORDINATE, // control point coordinates, real vector of length ndim  nr

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_UVW_NUM_CTRL_PNTS_R
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_UVW_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nr

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_PATCH_ID, // physical univariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_NUM_CTRL_PNTS, // number of control points in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_DEGREE, //polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_KNOT_VECTOR_TYPE, // knot vector type in the local r - direction(optional, default unir = 0)

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_UVW_XYZ_CTRL_PNTS_R + IGAPOST_1D_NURBS_XYZ_DEGREE_R + 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ,
	*/
	IGAPOST_1D_NURBS_XYZ_KNOT_VECTOR, // knot vector in the local r - direction(iff unir = 0),  real vector of length nr + pr + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ,
	*/
	IGAPOST_1D_NURBS_XYZ_KNOT_FIRST, // first knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ,
	*/
	IGAPOST_1D_NURBS_XYZ_KNOT_LAST, // last knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_XYZ
	*/
	IGAPOST_1D_NURBS_XYZ_NUM_DIM, // number of parametric dimensions the NURBS is embedded in

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_XYZ_NUM_DIM * IGAPOST_1D_NURBS_XYZ_NUM_CTRL_PNTS_R
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_XYZ_CTRL_PNT_COORDINATE, // control point coordinates, real vector of length ndim  nr

	/**
	* conversion: double
	* length    : IGAPOST_1D_NURBS_XYZ_NUM_CTRL_PNTS_R
	* parameters: index base from 0 to IGAPOST_NUM_1D_NURBS_UVW
	*/
	IGAPOST_1D_NURBS_XYZ_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nr

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_DIM, // dimension, 2 or 3

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_PATCH_ID, // physical bivariate spline ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_CTRL_PNTS, // number of control points in the patch

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_ELEM, // number of elements in the patch

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_COEFF_VECTOR, // number of coefficient vectors in the patch

	/**
	* conversion: double
	* length    : 3 * IGAPOST_ND_BEZIER_XYZ_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_CTRL_PNT_COORDINATE, // control point coordinates, real vector of length 3  nnp

	/**
	* conversion: double
	* length    : IGAPOST_ND_BEZIER_XYZ_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nnp

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_ELEM_BLOCK, // number of element blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_TYPE, // element type

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_ELEM, // number of elements in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_CTRL_PNTS, // number of control points per element

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_COEFF_VECTOR, // number of coefficient vector IDs per element

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_DEGREE_R, // polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_DEGREE_S, // polynomial degree in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_DEGREE_T, // polynomial degree in the local t - direction(n = 3 only)

	/**
	* conversion: int
	* length    : IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_ELEM * IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_CONN, // array of nodal connectivities for all elements in the block, LSDA I8 integer vector of length ne  nn
						//note : local node IDs are replaced with global ones

	/**
	* conversion: int
	* length    : IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_ELEM * IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_COEFF_VECTOR
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_COEFF, //array of coefficient vector IDs for all elements in the block, integer vector of length ne  ncv

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_DENSE_COEFF_BLOCK, // number of dense coefficient vector blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_DENSE_NUM_COEFF_BLOCK, // number of coefficient vectors in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_DENSE_NUM_COEFF_COMPONENT, // number of coefficient vector components

	/**
	* conversion: double
	* length    : IGAPOST_ND_BEZIER_XYZ_DENSE_NUM_COEFF_BLOCK * IGAPOST_ND_BEZIER_XYZ_DENSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_DENSE_COEFF_COMPONENT, // number of coefficient vector components

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_NUM_SPARSE_COEFF_BLOCK, // number of sparse coefficient vector blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_BLOCK, // number of coefficient vectors in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_COMPONENT, // number of coefficient vector components

	/**
	* conversion: double
	* length    : IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_BLOCK * IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_SPARSE_COEFF_COMPONENT, // array of coefficient vector components for all vectors in the block, real array of length ncv  ncvc

	/**
	* conversion: int
	* length    : IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_BLOCK * IGAPOST_ND_BEZIER_XYZ_SPARSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BEZIER_XYZ_SPARSE_INDEX_COEFF_COMPONENT, // array of coefficient vector components for all vectors in the block, real array of length ncv  ncvc

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_2D_BREP
	*/
	IGAPOST_2D_BREP_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_BREP
	*/
	IGAPOST_2D_BREP_ID, // two - dimensional B-rep ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_BREP
	*/
	IGAPOST_2D_BREP_NUM_FACE, // number of faces

	/**
	* conversion: int
	* length    : IGAPOST_2D_BREP_NUM_FACE
	* parameters: index base from 0 to IGAPOST_NUM_2D_BREP
	*/
	IGAPOST_2D_BREP_FACE_ID, // parametric face IDs, integer vector of length nfid

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_ID, // parametric bivariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_R, // number of control points in the local r - direction

	/**
	* conversion: int
	* length    : IGAPOST_2D_BREP_NUM_FACE
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_S, // number of control points in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_DEGREE_R, // polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_DEGREE_S, // polynomial degree in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_TYPE_R, // knot vector type in the local r - direction(optional, default unir = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_TYPE_S, // knot vector type in the local s - direction(optional, default unis = 0)

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_UVW_DEGREE_R + IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_R +1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_VECTOR_R, // knot vector in the local r - direction(iff unir = 0), real vector of length nr + pr + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_R_FIRST, // first knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_R_LAST, // last knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_UVW_DEGREE_S + IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_S +1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_VECTOR_S, // knot vector in the local s - direction(iff unis = 0), real vector of length ns + ps + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_S_FIRST, // first knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_KNOT_S_LAST, // last knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_NUM_DIM, // number of parametric dimensions the NURBS is embedded in

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_UVW_NUM_DIM * IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_R * IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_S
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_CTRL_PNT, // control point coordinates, real vector of length ndim  nr  ns

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_R * IGAPOST_2D_NURBS_UVW_NUM_CTRL_PNTS_S
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_UVW
	*/
	IGAPOST_2D_NURBS_UVW_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nr  ns

/////////////////////////////////////////////////////////////
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_ID, // physical bivariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_R, // number of control points in the local r - direction

	/**
	* conversion: int
	* length    : IGAPOST_2D_BREP_NUM_FACE
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_S, // number of control points in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_DEGREE_R, // polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_DEGREE_S, // polynomial degree in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_TYPE_R, // knot vector type in the local r - direction(optional, default unir = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_TYPE_S, // knot vector type in the local s - direction(optional, default unis = 0)

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_XYZ_DEGREE_R + IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_R +1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_VECTOR_R, // knot vector in the local r - direction(iff unir = 0), real vector of length nr + pr + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_R_FIRST, // first knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_R_LAST, // last knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_XYZ_DEGREE_S + IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_S +1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_VECTOR_S, // knot vector in the local s - direction(iff unis = 0), real vector of length ns + ps + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_S_FIRST, // first knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_KNOT_S_LAST, // last knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: double
	* length    : 3 * IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_S
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_CTRL_PNT, // control point coordinates, real vector of length 3  nr  ns

	/**
	* conversion: double
	* length    : IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_S
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nr  ns

	/**
	* conversion: int
	* length    : IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_2D_NURBS_XYZ_NUM_CTRL_PNTS_S
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_2D_NURBS_XYZ_CTRL_PNT_ID, // list of global control point IDs, LSDA_I8 integer vector of length nr  ns
					//note : zero ID is assigned to control points unused due to trimming

	/******************************* 3D NURBS XYZ Types *******************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_ID, // physical trivariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_R, // number of control points in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_S, // number of control points in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_T, // number of control points in the local t - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_DEGREE_R, // polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_DEGREE_S, // polynomial degree in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_DEGREE_T, // polynomial degree in the local t - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_TYPE_R, // knot vector type in the local r - direction(optional, default unir = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_TYPE_S, // knot vector type in the local s - direction(optional, default unis = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_TYPE_T, // knot vector type in the local t - direction(optional, default unit = 0)

	/**
	* conversion: double
	* length    : IGAPOST_3D_NURBS_XYZ_DEGREE_R + IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_R +1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_VECTOR_R, // knot vector in the local r - direction(iff unir = 0), real vector of length nr + pr + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_R_FIRST, // first knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_R_LAST, // last knot value in the local r - direction(iff unir = 0)

	/**
	* conversion: double
	* length    : IGAPOST_3D_NURBS_XYZ_DEGREE_S + IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_S +1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_VECTOR_S, // knot vector in the local s - direction(iff unis = 0), real vector of length ns + ps + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_S_FIRST, // first knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_2D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_S_LAST, // last knot value in the local s - direction(iff unis = 0)

	/**
	* conversion: double
	* length    : IGAPOST_3D_NURBS_XYZ_DEGREE_T + IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_T +1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_VECTOR_T, // knot vector in the local t - direction(iff unis = 0), real vector of length nt + pt + 1

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_T_FIRST, // first knot value in the local t - direction(iff unit = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_KNOT_T_LAST, // last knot value in the local t - direction(iff unit = 0)

	/**
	* conversion: double
	* length    : 3 * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_S* IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_T
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_CTRL_PNT, // control point coordinates, real vector of length 3  nr  ns  nt

	/**
	* conversion: double
	* length    : IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_S * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_T
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nr  ns  nt

	/**
	* conversion: int
	* length    : IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_R * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_S * IGAPOST_3D_NURBS_XYZ_NUM_CTRL_PNTS_T
	* parameters: index base from 0 to IGAPOST_NUM_3D_NURBS_XYZ
	*/
	IGAPOST_3D_NURBS_XYZ_CTRL_PNT_ID, // list of global control point IDs, LSDA_I8 integer vector of length nr  ns  nt
					//note : zero ID is assigned to control points unused due to trimming

	/******************************* Edge UVW Types *******************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_BEZIER, //v1.0 only, Bezier option(optional, default BEZIER = 0)
			//= 0 : edge defined in / on a structured spline
			//= 1 : edge defined in / on an unstructured spline, LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_BASIS_TRANSFORM, //after v1.1, basis transform option(optional, default BASIS_TRANSFORM = 0)
			//= 0 : edge defined in / on a structured spline
			//= 1 : edge defined in / on an unstructured spline, LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_PARAM_ID, //parametric edge ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_PHYSIC_ID, //physical edge ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_PATCH_ID, //parametric univariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_SENSE, //sense of orientation with respect to the parametric univariate NURBS
					//(optional, default sense = 0)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_R_START, //parametric coordinate defining the start of the parametric univariate NURBS(optional)

	/**
	* conversion: double
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_R_END, //parametric coordinate defining the end of the parametric univariate NURBS(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_BEZIER_ELEM_ID, //v1.0 only, element(iff BEZIER = 1)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_ELEM_ID, //after v1.1, element(iff BASIS_TRANSFORM = 1)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_UVW
	*/
	IGAPOST_EDGE_UVW_EDGE_ID, //element edge ID(iff BEZIER = 1)

	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_PHYSIC_ID, //physical edge ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_PATCH_ID, //physical univariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_ORIENTATION, //orientation with respect to the physical univariate NURBS(optional, default ori = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_START_PNT_ID, // parametric point ID defining the start of the trimmed physical NURBS (optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_END_PNT_ID, //parametric point ID defining the end of the trimmed physical NURBS (optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_EDGE_XYZ
	*/
	IGAPOST_EDGE_XYZ_PNT_SET_ID, //parametric point set ID(optional)

	/********************* Face UVW Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_BEZIER, // v1.0 only, Bezier option(optional, default BEZIER = 0)
			//	= 0 : face defined in / on a structured spline
			//= 1 : face defined in / on an unstructured spline
			//LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_BASIS_TRANSFORM, // after v1.1, basis transform option(optional, default BASIS_TRANSFORM = 0)
		//	= 0 : face defined in / on a structured spline
		//= 1 : face defined in / on an unstructured spline

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_PARAM_ID, // parametric face ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_PHYSICAL_ID, // physical face ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_PATCH_ID, // parametric bivariate NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_SENSE, // sense of orientation with respect to the parametric bivariate NURBS
					//(optional, default sense = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_NUM_BREP_ID, // nbrid, num boundary representation IDs

	/**
	* conversion: int
	* length    : IGAPOST_FACE_UVW_NUM_BREP_ID
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_BREP_ID, // one - dimensional boundary representation IDs(iff BEZIER = 0,
			//iff BASIS_TRANSFORM=0 after v1.1), integer vector of length nbrid

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_BEZIER_ELEM_ID, // v1.0 only, element ID(iff BEZIER = 1)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_ELEM_ID, // after v1.1, element ID(iff BASIS_TRANSFORM = 1)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_UVW_ELEM_FACE_ID, // element face ID(iff BEZIER = 1, iff BASIS_TRANSFORM=1 after v1.1)

	/********************* Face XYZ Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_BEZIER, // v1.0 only, Bezier option(optional, default BEZIER = 0)
						//= 0 : face is referencing a structured bivariate spline
						//= 1 : face is referencing an unstructured bivariate spline

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_BASIS_TRANSFORM, // after v1.1, basis transform option(optional, default BASIS_TRANSFORM = 0)
						//= 0 : face is referencing a structured bivariate spline
						//= 1 : face is referencing an unstructured bivariate spline

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_PHYSICAL_ID, // physical face ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_PATCH_ID, // physical bivariate BEZIER or NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_ORIENTATION, // orientation with respect to the physical bivariate NURBS(optional, default ori = 0)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_PNT_SET_ID, // parametric point set ID(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_EDGE_SET_ID, // parametric edge set ID(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_NUM_1D_BREP, // number of one - dimensional boundary representation IDs

	/**
	* conversion: int
	* length    : IGAPOST_FACE_XYZ_NUM_1D_BREP
	* parameters: index base from 0 to IGAPOST_NUM_FACE_XYZ
	*/
	IGAPOST_FACE_XYZ_1D_BREP_ID, // one - dimensional boundary representation IDs(iff BEZIER = 0, 
					// BASIS_TRANSFORM=0 after v1.1), integer vector of length nbrid

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_NUM_BEZIER_ID, // v1.0 only, element face ID(iff BEZIER = 1, iff BASIS_TRANSFORM=1 after v1.1)

	/**
	* conversion: int
	* length    : IGAPOST_FACE_XYZ_NUM_BEZIER_ID
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_BEZIER_ID, // v1.0 only, local element IDs defining part of the surface(optional, iff BEZIER = 1), integer vector of length nebzrid

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_NUM_ELEM_ID, //local element IDs defining part of the surface(optional, iff BASIS_TRANSFORM = 1), integer vector of length nelid

	/**
	* conversion: int
	* length    : IGAPOST_FACE_XYZ_NUM_BEZIER_ID
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_FACE_XYZ_ELEM_ID, // local element IDs defining part of the surface(optional, iff BASIS_TRANSFORM = 1), integer vector of length nelid

	/********************* Point UVW Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_BEZIER, // v1.0 only, Bezier option(optional, defaults to BEZIER = 0 if not defined)
						//= 0 : point defined in / on a structured spline
						//= 1 : point defined in / on an unstructured spline, LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_BASIS_TRANSFORM, // after v1.1, basis transform option(optional, defaults to BASIS_TRANSFORM = 0 if not defined)
						//= 0 : point defined in / on a structured spline
						//= 1 : point defined in / on an unstructured spline, LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_PARAM_ID, // parametric point ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_NODE_ID, // node ID

	/**
	* conversion: double
	* length    : 3
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_PARAM_POINT_COORD, // parametric point coordinates (DZH: the length of uvw is not defiend, I guess it should be 2 )

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_POINT_UVW
	*/
	IGAPOST_POINT_UVW_BEZIER_ELEM_ID, // v1.0 only, element ID(optional, iff BEZIER = 1)

	/**
	* conversion: int
	* length    : IGAPOST_FACE_XYZ_NUM_BEZIER_ID
	* parameters: index base from 0 to IGAPOST_NUM_FACE_UVW
	*/
	IGAPOST_POINT_UVW_ELEM_ID, // after v1.1, element ID(optional, iff BASIS_TRANSFORM = 1)

	/********************* Shell Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_ID, // isogeometric shell ID;

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_PART_ID, // part ID LSDA_I8

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_NUM_HISTORY_VAR, // number of history variables

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_NUM_INTEGRATION_PNT, // number of through the thickness integration points requested for post processing
					//note : might be different from the input on the section keyword card

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_NUM_CTRL_PNT, // list of control point IDs, LSDA I8 integer vector of length nna

	/**
	* conversion: int
	* length    : IGAPOST_SHELL_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_SHELL
	*/
	IGAPOST_SHELL_CTRL_PNT_ID, // list of control point IDs, LSDA I8 integer vector of length nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_DISPLACEMENT, // displacement vector, LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_ROTATION, // rotation vector(optional), LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_VELOCITY, // velocity vector, LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_ROTATION_VELOCITY, // rotational velocity vector(optional), LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_ACCELERATION, // acceleration vector, LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : 3*IGAPOST_SHELL_NUM_CTRL_PNT/IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_ROTATION_ACCELERATION, // rotational acceleration vector(optional), LSDA REAL vector of length 3  nna

	/**
	* conversion: int
	* length    : (7+IGAPOST_SHELL_NUM_HISTORY_VAR)* IGAPOST_SHELL_NUM_CTRL_PNT*IGAPOST_SHELL_NUM_INTEGRATION_PNT or
	*			  (7+IGAPOST_SOLID_NUM_HISTORY_VAR)* IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_STATE
	*/
	IGAPOST_STATE_HISTORY, // history variables, LSDA REAL vector of length(7 + nhv)  nna  nip
				//such that
				//hv(1 - 6, *, *) : components of the Cauchy stress tensor
				//hv( 7, *, *) : effective plastic strain unless otherwise noted
				//hv(8 - , *, *) : requested history variables

	/********************* Solid Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_ID, // isogeometric solid ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_PART_ID, // part ID LSDA_I8

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_NUM_HISTORY_VAR, // number of history variables

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_NUM_CTRL_PNT, // number of through the thickness integration points requested for post processing
					//note : might be different from the input on the section keyword card

	/**
	* conversion: int
	* length    : IGAPOST_SOLID_NUM_CTRL_PNT
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_SOLID_CTRL_PNT_ID, // list of control point IDs, LSDA I8 integer vector of length nna

	/********************* Volume XYZ Types ****************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_VOLUME_XYZ
	*/
	IGAPOST_VOLUME_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_BEZIER, // v1.0 only, Bezier option(optional, default BEZIER = 0)
						//= 0 : volume is referencing a structured trivariate spline
						//= 1 : volume is referencing an unstructured trivariate spline, LSDA INTEGER 

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_BASIS_TRANSFORM, // after v1.1, basis transform option(optional, default BASIS_TRANSFORM = 0)
						//= 0 : volume is referencing a structured trivariate spline
						//= 1 : volume is referencing an unstructured trivariate spline, LSDA INTEGER

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_PHYSICAL_ID, // physical volume ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_PATCH_ID, // physical trivariate BEZIER or NURBS ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_POINT_SET_ID, // parametric point set ID(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_EDGE_SET_ID, // parametric edge set ID(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_FACE_SET_ID, // parametric face set ID(optional)

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_NUM_BREP, // number of two - dimensional boundary representation IDs

	/**
	* conversion: int
	* length    : IGAPOST_VOLUME_XYZ_NUM_BREP
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_BREP_ID, // two - dimensional boundary representation IDs(iff BEZIER = 0), integer vector of length nbrid

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_NUM_BEZIER_ELEM, // v1.0 only, number of local element IDs defining part of the volume(optional, iff BEZIER =1), integer vector of length nebzrid

	/**
	* conversion: int
	* length    : IGAPOST_VOLUME_XYZ_NUM_BEZIER_ELEM
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_BEZIER_ELEM_ID, // v1.0 only, local element IDs defining part of the volume(optional, iff BEZIER =1), integer vector of length nebzrid

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_NUM_ELEM, // v1.0 only, number of local element IDs defining part of the volume(optional, iff BASIS_TRANSFORM =1), integer vector of length nebzrid

	/**
	* conversion: int
	* length    : IGAPOST_VOLUME_XYZ_NUM_ELEM
	* parameters: index base from 0 to IGAPOST_NUM_SOLID
	*/
	IGAPOST_VOLUME_XYZ_ELEM_ID, // after v1.1, local element IDs defining part of the volume(optional, iff BASIS_TRANSFORM =1), integer vector of length nebzrid

	/**************************** nD BASIS TRANSFORM Types ************************************/
	/**
	* conversion: char
	* length    : 64
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NAME,

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_DIM, // dimension, 2 or 3

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_PATCH_ID, // physical bivariate spline ID

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_CTRL_PNTS, // number of control points in the patch

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_ELEM, // number of elements in the patch

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_COEFF_VECTOR, // number of coefficient vectors in the patch

	/**
	* conversion: double
	* length    : 3 * IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_CTRL_PNT_COORDINATE, // control point coordinates, real vector of length 3  nnp

	/**
	* conversion: double
	* length    : IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_CTRL_PNT_WEIGHT, // control weights(optional), real vector of length nnp

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_ELEM_BLOCK, // number of element blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_TYPE, // element type

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_NUM_ELEM, // number of elements in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_NUM_CTRL_PNTS, // number of control points per element

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_NUM_COEFF_VECTOR, // number of coefficient vector IDs per element

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_DEGREE_R, // polynomial degree in the local r - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_DEGREE_S, // polynomial degree in the local s - direction

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_DEGREE_T, // polynomial degree in the local t - direction(n = 3 only)

	/**
	* conversion: int
	* length    : IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_ELEM * IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_NUM_CTRL_PNTS
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_CONN, // array of nodal connectivities for all elements in the block, LSDA I8 integer vector of length ne  nn
						//note : local node IDs are replaced with global ones

	/**
	* conversion: int
	* length    : IGAPOST_ND_BEZIER_XYZ_ELEM_BLOCK_NUM_ELEM * IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_NUM_COEFF_VECTOR
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_ELEM_BLOCK_COEFF, //array of coefficient vector IDs for all elements in the block, integer vector of length ne  ncv

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_DENSE_COEFF_BLOCK, // number of dense coefficient vector blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_DENSE_NUM_COEFF_BLOCK, // number of coefficient vectors in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_DENSE_NUM_COEFF_COMPONENT, // number of coefficient vector components

	/**
	* conversion: double
	* length    : IGAPOST_ND_BEZIER_XYZ_DENSE_NUM_COEFF_BLOCK * IGAPOST_ND_BASIS_TRANSFORM_XYZ_DENSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_DENSE_COEFF_COMPONENT, // array of coefficient vector components for all vectors in the block, real array of length ncv  ncvc

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_NUM_SPARSE_COEFF_BLOCK, // number of sparse coefficient vector blocks

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BEZIER_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_BLOCK, // number of coefficient vectors in the block

	/**
	* conversion: int
	* length    : 1
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_COMPONENT, // number of coefficient vector components

	/**
	* conversion: double
	* length    : IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_BLOCK * IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_COEFF_COMPONENT, // array of coefficient vector components for all vectors in the block, real array of length ncv  ncvc

	/**
	* conversion: int
	* length    : IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_BLOCK * IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_NUM_COEFF_COMPONENT
	* parameters: index base from 0 to IGAPOST_NUM_ND_BASIS_TRANSFORM_XYZ
	*/
	IGAPOST_ND_BASIS_TRANSFORM_XYZ_SPARSE_INDEX_COEFF_COMPONENT, // array of coefficient vector components for all vectors in the block, real array of length ncv  ncvc

};

typedef struct IGAPost_Parameter_
{
	/**
	* the entity id, default is 0
	*/
	int id;
	/**
	* the number through thickness integration point,  default is 1
	*/
	int ipt;
	/**
	 * the number of history variable, and default is 1
	*/
	int ihv;
	/**
	* the partid id for abstat_cpm, and default is 0
	*/
	int partid;
	/*
	* state index default is 0
	*/
	int stateindex;
	/**
	* the option  for BINOUT_DataType
	*/
	IGAPost_DataType datatype_option;

	IGAPost_Parameter() : id(0), ipt(1), nqt(0), npl(1), freq_mode(1), cid(0), nodeset(0), ihv(1), wallid(1), partid(0), speciesid(1), stateindex(0), idtype(BINOUT_IDTYPE_NONE), datatype_option(BINOUT_DATATYPE_GENERAL)
	{
	}
}IGAPost_Parameter;


#endif

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus
	
	CREADERAPI void*  IGAPost_Open(const char* filename);
	CREADERAPI void   IGAPost_Close(void* handle);
	// Recommended API
	CREADERAPI void  IGAPost_InitParameter(_IGAPOST_Parameter* param);
	CREADERAPI int   IGAPost_Read(char* handle, enum IGAPost_DataType type, char* value, const _IGAPOST_Parameter* param);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // !__IGAPOST_READER_WRAPPER_C_H__

        