#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "../config.h"
#include "d3plotreaderc.h"
#include "binoutreaderc.h"

int main()
{
	
    unsigned int i = 0;
	char* handle = NULL;
	char d3plot_file[1024];
	char lsda_file[1024];
	char lsda_config[1024];
	char* handle_lsda = NULL;
	int shell_num = 0;
	_D3P_Tensor* shell_stress = NULL;
	_D3P_Parameter dp;
	
	//======================D3plotReader======================
	D3P_Init(&dp);
    strcpy(d3plot_file, DATA_PATH_D3P);
	strcpy(lsda_file, OUTPUT_LSDA_PATH_C);
	strcpy(lsda_config, LSDA_CONFIG);
    
#ifdef WIN32		
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '/') {
            d3plot_file[i] = '\\';
        }
    }
#else
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '\\') {
            d3plot_file[i] = '/';
        }
    }
#endif
    
#ifdef WIN32		
    for(i=0; i<strlen(lsda_file); i++) {
        if(lsda_file[i] == '/') {
            lsda_file[i] = '\\';
        }
    }
#else
    for(i=0; i<strlen(lsda_file); i++) {
        if(lsda_file[i] == '\\') {
            lsda_file[i] = '/';
        }
    }
#endif

#ifdef WIN32		
    for(i=0; i<strlen(lsda_config); i++) {
        if(lsda_config[i] == '/') {
            lsda_config[i] = '\\';
        }
    }
#else
    for(i=0; i<strlen(lsda_config); i++) {
        if(lsda_config[i] == '\\') {
            lsda_config[i] = '/';
        }
    }
#endif

	handle = D3P_Open(d3plot_file);
	if (!handle)
		goto cleanup;
	D3P_WriteLsdaFile(handle, lsda_file, lsda_config);
	handle_lsda = D3P_OpenD3lsda(lsda_file);

	D3P_Read(handle_lsda, D3P_NUM_SHELL, (char*)&shell_num, dp);
	dp.ist = 11;
	dp.ipt = 0;
	shell_stress = (_D3P_Tensor*)malloc(sizeof(_D3P_Tensor)*shell_num);
	D3P_Read(handle_lsda, D3P_SHELL_STRESS, (char*)shell_stress, dp);

cleanup:
	if(handle)
		free(handle);
	if(handle_lsda)
		free(handle_lsda);
	if(shell_stress)
		free(shell_stress);
}