#include <string.h>
#include <iostream>
#include <vector>

#include "../config.h"
#include "d3plotreader.h"
#include "binoutreader.h"
using namespace std;

int main()
{
	//======================D3plotReader======================
	string d3plot_file = DATA_PATH_D3P;
	string lsda_file = OUTPUT_LSDA_PATH_C;
	string lsda_config = LSDA_CONFIG;

#ifdef WIN32
    string::size_type pos = d3plot_file.find('/');
	while(pos != string::npos)
	{
		d3plot_file.replace(pos, 1, "\\");
		pos = d3plot_file.find('/');
	}
#else
	 string::size_type pos = d3plot_file.find('\\');
	while(pos != string::npos)
	{
		d3plot_file.replace(pos, 1, "/");
		pos = d3plot_file.find('\\');
	}
#endif

#ifdef WIN32
    pos = lsda_file.find('/');
	while(pos != string::npos)
	{
		lsda_file.replace(pos, 1, "\\");
		pos = lsda_file.find('/');
	}
#else
	 pos = lsda_file.find('\\');
	while(pos != string::npos)
	{
		lsda_file.replace(pos, 1, "/");
		pos = lsda_file.find('\\');
	}
#endif

#ifdef WIN32
    pos = lsda_config.find('/');
	while(pos != string::npos)
	{
		lsda_config.replace(pos, 1, "\\");
		pos = lsda_config.find('/');
	}
#else
	 pos = lsda_config.find('\\');
	while(pos != string::npos)
	{
		lsda_config.replace(pos, 1, "/");
		pos = lsda_config.find('\\');
	}
#endif
    
	D3plotReader dr(d3plot_file.c_str());
	dr.WriteLsdaFile(lsda_file.c_str(), lsda_config.c_str());

	D3plotReader drlsda(lsda_file.c_str(), "d3lsda");
	int shellNum = 0;
	drlsda.GetData(D3P_NUM_SHELL, (char*)&shellNum);
	vector<D3P_Tensor> shellStress(shellNum);
	D3P_Parameter dp;
	dp.ist = 11;
	dp.ipt = 0;
	drlsda.GetData(D3P_SHELL_STRESS, (char*)shellStress.data(), dp);

}