#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "../config.h"
#include "d3plotreaderc.h"
#include "binoutreaderc.h"
static int test_femzip()
{
	int success = 0;
	char femzip_file[1024];
	int i = 0;
	char* handle;
	int num_shell = 0;
	int num_state = 0;
	int num_nodes = 0;
	int* nodal_ids = NULL;
	int* shell_ids = NULL;
	int internal_id = -1;
	_D3P_Control control;
	_D3P_Parameter dp;
	_D3P_Shell* shell_conn = NULL;
	_D3P_Tensor* shell_stress = NULL;
	D3P_Init(&dp);
	strcpy(femzip_file, DATA_PATH_FEMZIP);
	handle = D3P_Open(femzip_file);
	if (!handle)
		goto cleanup;
	if (!D3P_Read(handle, D3P_CONTROL, (char*)&control, dp))
		goto cleanup;

	if (!D3P_Read(handle, D3P_NUM_SHELL, (char*)&num_shell, dp))
		goto cleanup;
	printf("num_shell: %d\n", num_shell);

	if (!D3P_Read(handle, D3P_NUM_STATES, (char*)&num_state, dp))
		goto cleanup;
	printf("num_state: %d\n", num_state);

	if (!D3P_Read(handle, D3P_NUM_NODES, (char*)&num_nodes, dp))
		goto cleanup;
	printf("num_nodes: %d\n", num_nodes);

	nodal_ids = (int*)malloc(num_nodes * sizeof(int));
	if (!D3P_Read(handle, D3P_NODE_IDS, (char*)nodal_ids, dp))
		goto cleanup;

	shell_ids = (int*)malloc(num_shell * sizeof(int));
	if (!D3P_Read(handle, D3P_SHELL_IDS, (char*)shell_ids, dp))
		goto cleanup;

	dp.iuser = 3;
	if (!D3P_Read(handle, D3P_SHELL_INTERNAL_ID, (char*)&internal_id, dp))
		goto cleanup;
	printf("internal_id: %d\n", internal_id);

	shell_conn = (_D3P_Shell*)malloc(num_shell * sizeof(_D3P_Shell));
	if (!D3P_Read(handle, D3P_SHELL_CONNECTIVITY_MAT, (char*)shell_conn, dp))
		goto cleanup;
	printf("shell_conn[0](%d, %d, %d, %d)\n", nodal_ids[shell_conn[0].conn[0] - 1], nodal_ids[shell_conn[0].conn[1] - 1], nodal_ids[shell_conn[0].conn[2] - 1], nodal_ids[shell_conn[0].conn[3] - 1]);

	dp.ist = 24;
	dp.ipt = 2;
	shell_stress = (_D3P_Tensor*)malloc(num_shell * sizeof(_D3P_Tensor));
	if (!shell_stress)
		goto cleanup;
	if (!D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress, dp))
		goto cleanup;
	printf("shell_stress[0](%f, %f, %f, %f, %f, %f)\n", shell_stress[0].t[0], shell_stress[0].t[1], shell_stress[0].t[2], shell_stress[0].t[3], shell_stress[0].t[4], shell_stress[0].t[5]);

	free(shell_conn); shell_conn = NULL;
	free(nodal_ids); nodal_ids = NULL;
	free(shell_ids); shell_ids = NULL;
	free(shell_stress); shell_stress = NULL;

	success = 1;
cleanup:
	if (nodal_ids)
		free(nodal_ids); nodal_ids = NULL;
	if (shell_ids)
		free(shell_ids); shell_ids = NULL;
	if (shell_conn)
		free(shell_conn); shell_conn = NULL;
	if (shell_stress)
		free(shell_stress); shell_stress = NULL;
	if (handle)
		D3P_Close(handle);

	return success;
}
int main()
{
	
    unsigned int i = 0;
    char d3plot_file[1024];
	char title[80];
	char* handle = NULL;
    int ns = 0, nn = 0, nsh = 0;
    int* nodal_ids = NULL;
    _D3P_Vector* coords = NULL;
    _D3P_VectorDouble* dcoords = NULL;
    _D3P_Shell* shell_conn = NULL;
    _D3P_Tensor * shell_stress = NULL;
	float* shell_history_var = NULL;
	_D3P_Tensor* shell_stress_bypart = NULL;
    _D3P_Parameter dp;
	size_t size = 0;
    
	char binout_files[1024];
	char out_path[1024];
	char* handle_binout = NULL;
	char** branches = NULL;
	size_t max_branch = 0;
	unsigned int num_branch = 0;
	unsigned int num_id = 0;
	unsigned int num_array = 0;
	double* x_array = NULL;
	double* y_array = NULL;
	unsigned int* ids = NULL;
	
	//======================D3plotReader======================
	D3P_Init(&dp);
    strcpy(d3plot_file, DATA_PATH_D3P);
    
#ifdef WIN32		
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '/') {
            d3plot_file[i] = '\\';
        }
    }
#else
    for(i=0; i<strlen(d3plot_file); i++) {
        if(d3plot_file[i] == '\\') {
            d3plot_file[i] = '/';
        }
    }
#endif
    
	handle = D3P_Open(d3plot_file);
	if (!handle)
		goto cleanup;
	
	D3P_Read(handle, D3P_TITLE, (char*)title, dp);
	i = 0;
	printf("title: ");
	for(i=0;i<strlen(title);i++)
	{
		printf("%c", title[i]);
	}
	printf("\n");

    D3P_Read(handle, D3P_NUM_STATES, (char*)&ns, dp);
    printf("num states: %d\n", ns);

    
    D3P_Read(handle, D3P_NUM_NODES, (char*)&nn, dp);
    printf("num nodes: %d\n", nn);

	size = nn * sizeof(int);
	nodal_ids = (int*)malloc(size);
	D3P_Read(handle, D3P_NODE_IDS, (char*)nodal_ids, dp);

    D3P_Read(handle, D3P_NUM_SHELL, (char*)&nsh, dp);
    printf("num shells: %d\n", nsh);

	size = nsh * sizeof(_D3P_Shell);
	shell_conn = (_D3P_Shell*)malloc(size);
	D3P_Read(handle, D3P_SHELL_CONNECTIVITY_MAT, (char*)shell_conn, dp);
	if (!size || !shell_conn || !nodal_ids)
		goto cleanup;
	printf("shell_conn[0](%d, %d, %d, %d)\n", nodal_ids[shell_conn[0].conn[0]-1], nodal_ids[shell_conn[0].conn[1]-1], nodal_ids[shell_conn[0].conn[2]-1], nodal_ids[shell_conn[0].conn[3]-1]);

	size = nn * sizeof(_D3P_Vector);
    coords = (_D3P_Vector*) malloc (size);
    dp.ist = 0;
    D3P_Read(handle, D3P_NODE_COORDINATES, (char*)coords, dp);
	if (!size || !coords)
		goto cleanup;
	printf("coords[211](%f, %f, %f) at the first state\n", coords[nn-1].v[0], coords[nn-1].v[1], coords[nn-1].v[2]);

    dp.ist = 11;
    D3P_Read(handle, D3P_NODE_COORDINATES, (char*)coords, dp);
	printf("coords[211](%.10f, %.10f, %.10f) at the last state\n", coords[nn-1].v[0], coords[nn-1].v[1], coords[nn-1].v[2]);
    

	size = nn * sizeof(_D3P_VectorDouble);
	dcoords = (_D3P_VectorDouble*)malloc(size);
    D3P_Read(handle, D3P_NODE_COORDINATES_DOUBLE, (char*)dcoords, dp);
	if (!size || !dcoords)
		goto cleanup;
	printf("coords[211](%.10f, %.10f, %.10f) at the last state\n", dcoords[nn-1].v[0], dcoords[nn-1].v[1], dcoords[nn-1].v[2]);

    dp.ipt = 2;
	size = nsh * sizeof(_D3P_Tensor);
	shell_stress = (_D3P_Tensor*)malloc(size);
	D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress, dp);
	if (!size || !shell_stress)
		goto cleanup;
	printf("shell_stress[0](%f, %f, %f, %f, %f, %f)\n", shell_stress[0].t[0], shell_stress[0].t[1], shell_stress[0].t[2], shell_stress[0].t[3], shell_stress[0].t[4], shell_stress[0].t[5]);
	

	dp.ist = 0;
	dp.ipt = 0;
	dp.ihv = 1;
	size = nsh * sizeof(float);
	shell_history_var = (float*)malloc(size);
	D3P_Read(handle, D3P_SHELL_HISTORY_VAR, (char*)shell_history_var,dp);
	if (!size || !shell_history_var)
		goto cleanup;
	printf("shell_history_var[0]: %f\n", shell_history_var[0]);

	D3P_Init(&dp);
	dp.ipart_user = 1;
	D3P_Read(handle, D3P_NUM_SHELL, (char*)&nsh, dp);
	printf("ipart_user=1, num:%d\n", nsh);

	shell_stress_bypart = (_D3P_Tensor*)malloc(nsh * sizeof(_D3P_Tensor));
	dp.ist = 5;
	dp.ipt = 0;
	dp.ipart_user = 1;
	D3P_Read(handle, D3P_SHELL_STRESS, (char*)shell_stress_bypart, dp);
	printf("ipart_user=1, shell_stress[10].t[0]: %f", shell_stress_bypart[10].t[0]);
	

    D3P_Close(handle);

cleanup:
	if(shell_conn)
		free(shell_conn);
	if(nodal_ids)
		free(nodal_ids);
	if(coords)
		free(coords);
	if(shell_stress)
		free(shell_stress);
	if(shell_history_var)
		free(shell_history_var);
	if (shell_stress_bypart)
		free(shell_stress_bypart);

	//======================BinoutReader======================
	strcpy(binout_files, DATA_PATH_BINOUT);

#ifdef WIN32		
	for (i = 0; i < strlen(binout_files); i++) {
		if (binout_files[i] == '/') {
			binout_files[i] = '\\';
		}
	}
#else
	for (i = 0; i < strlen(binout_files); i++) {
		if (binout_files[i] == '\\') {
			binout_files[i] = '/';
		}
	}
#endif

	strcpy(out_path, OUTPUT_PATH_C);

#ifdef WIN32		
	for (i = 0; i < strlen(out_path); i++) {
		if (out_path[i] == '/') {
			out_path[i] = '\\';
		}
	}
#else
	for (i = 0; i < strlen(out_path); i++) {
		if (out_path[i] == '\\') {
			out_path[i] = '/';
		}
	}
#endif

	printf("%d\n", Binout_IsValid(binout_files));

	handle_binout = Binout_Open(binout_files);

	if (!handle_binout)
		goto cleanup_binout;

	num_branch = Binout_GetNumberOfBranch(handle_binout, &max_branch);
	if (!num_branch)
		goto cleanup_binout;
	branches = (char**)calloc(num_branch, sizeof(char*));
	if (!branches)
		goto cleanup_binout;
	for (i = 0; i < num_branch; i++)
	{
		branches[i] = (char*)malloc(max_branch);
		if (branches[i])
			memset(branches[i], 0, max_branch);
		else
			goto cleanup_binout;
		
	}
	if (!Binout_GetBranch(handle_binout, branches))
		goto cleanup_binout;
	printf("Branches: \n");
	for (i = 0; i < num_branch; i++)
	{
		printf("%s,", branches[i]);
	}
	printf("\n");

	Binout_SetBranch(handle_binout, "nodout");
	num_id = Binout_GetNumberOfId(handle_binout);

	if (!num_id)
		goto cleanup_binout;
	ids = (unsigned int*)malloc(sizeof(unsigned int) * num_id);
	if (!ids)
		goto cleanup_binout;
	memset(ids, 0, sizeof(unsigned int) * num_id);
	
	if (!Binout_GetId(handle_binout, ids))
		goto cleanup_binout;
	printf("ids:\n");
	for (i = 0; i < num_id; i++)
	{
		printf("%d,", ids[i]);
	}
	printf("\n");

	Binout_SetId(handle_binout, 1787);
	Binout_SetComponent(handle_binout, "x_acceleration");

	num_array = Binout_GetNumberOfXArray(handle_binout);
	if (!num_array)
		goto cleanup_binout;
	x_array = (double*)malloc(sizeof(double) * num_array);
	y_array = (double*)malloc(sizeof(double) * num_array);
	if (!x_array || !y_array)
		goto cleanup_binout;
	memset(x_array, 0, sizeof(double) * num_array);
	memset(y_array, 0, sizeof(double) * num_array);

	Binout_GetXArray(handle_binout, x_array);
	Binout_GetYArray(handle_binout, y_array);

	Binout_Write(out_path, x_array, y_array, num_array);

cleanup_binout:
	if (handle_binout)
	{
		Binout_Close(handle_binout);
		handle_binout = NULL;
	}	
	if (branches)
	{
		for (i = 0; i < num_branch; i++)
		{
			if (branches[i])
			{
				free(branches[i]);
				branches[i] = NULL;
			}
		}
		free(branches);
		branches = NULL;
	}
	if (x_array)
	{
		free(x_array);
		x_array = NULL;
	}
	if (y_array)
	{
		free(y_array);
		y_array = NULL;
	}

	printf("enter femzip\n");
	test_femzip();

#ifdef WIN32
	system("pause");
#endif
}
