#ifndef __D3PLOT_READER_WRAPPER_C_H__
#define __D3PLOT_READER_WRAPPER_C_H__

#ifdef WIN32
#if defined (LSREADER_C_STATIC_LIB)
#define CREADERAPI
#else
#if defined (lsreader_c_EXPORTS)
#define CREADERAPI __declspec(dllexport)
#else // outside DLL
#define CREADERAPI __declspec(dllimport)
#endif
#endif

#else
#define CREADERAPI
#endif

#ifndef WIN32
#include <stdint.h>
typedef int64_t D3P_INTEGER_64;
#else
typedef __int64 D3P_INTEGER_64;
#endif

#include <wchar.h>

#if defined (__X64__)
typedef D3P_INTEGER_64 D3P_INT64;
#else
typedef unsigned long D3P_INT64;
#endif

#define LSREADER_VERSION "0.1.90"
#define LSR_MAJOR_VERSION 0
#define LSR_MINOR_VERSION 1
#define LSR_RELEASE_NUMBER 90
#define LSR_VERSION ( (LSR_MAJOR_VERSION * 1000) + (LSR_MINOR_VERSION * 100) + LSR_RELEASE_NUMBER )
#ifdef _DEBUG
#define D3P_ENABLE_MESSAGE
#endif // _DEBUG

#ifndef __D3P_RETURN_TYPE_ENUMERATIONS__
#define __D3P_RETURN_TYPE_ENUMERATIONS__
typedef enum _D3P_ReturnType
{
    /**
     * Input was as expected, output is as expected
     */
    D3P_SUCCESS=1,
	/**
	 * General error
	 */
	D3P_ERROR,
    /**
     * Parameter error
     */
    D3P_ERROR_PARAMETER,
    /**
     * Failed to read file
     */
    D3P_ERROR_FREAD,
	/**
	 * Failed to read femzip file
	 */
	D3P_ERROR_FREAD_FEMZIP,
	/**
	 * Failed to read unrecognized file
	 */
	D3P_ERROR_FREAD_UNRECOGNIZED,
	/**
	 * Failed to read non-existent file
	 */
	D3P_ERROR_FREAD_NONEXISTENT,
    /**
     * No data in database
     */
    D3P_WARNING_NO_DATA,
    /**
     * The type of element doesn't exist for current model.
     */
    D3P_WARNING_NO_ELEM,
	/**
	 * The type of lsda data doesn't exist for current model.
	 */
	LSDA_WARNING_NO_DATA,
} D3P_ReturnType;
#endif

#ifndef __D3P_MESSAGE_TYPE_ENUMERATIONS__
#define __D3P_MESSAGE_TYPE_ENUMERATIONS__
enum D3P_MessageType
{
    /**
     * Do not print information
     */
    D3P_MESSAGE_OFF,
    /**
     * Print brief information
     */
    D3P_MESSAGE_DEBUG,
     /**
      * Print verbose information
      */
    D3P_MESSAGE_VERBOSE,
};
#endif

#ifndef __D3P_DATA_TYPE_ENUMERATIONS__
#define __D3P_DATA_TYPE_ENUMERATIONS__

enum D3P_DataType
{

    /**
     * conversion: char[]
     * length    : 80
     * parameters: ignore
     */
    D3P_CODE_RELEASE,

    /**
     * conversion: char[]
     * length    : 80
     * parameters: ignore
     */
    D3P_TITLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_RIGID_BODY_SHELL_ELEMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_D3PLOT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_FEMZIP,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_INF,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_GLOBAL_KINETIC_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_GLOBAL_INTERNAL_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_GLOBAL_TOTAL_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_GLOBAL_VELOCITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_TITLE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive
     */
    D3P_HAS_PART_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_NAME,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_NAME_STRUCT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_INTERNAL_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_KINETIC_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_VELOCITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_MASS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PART_HOURGLASS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_RIGID_WALL_FORCE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_RIGID_WALL_POSITION,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_IS_ADAPTIVE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_THERMAL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_TEMPERATURE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_TEMPERATURE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_HEAT_FLUX,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_COORDINATES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_RAW_NODE_COORDINATES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_RAW_NODE_DISPLACEMENTS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_VELOCITIES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_ACCELERATIONS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_MASS_SCALING,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_TEMPERATURE_DIVIDE_TIME,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_RESIDUAL_FORCE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_RESIDUAL_MOMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_PENETRATION,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_RELATIVE_PENETRATION,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_NODE_CONTACT_ENERGY_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_STRAIN_RATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_THERMAL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SOLID_HISTORY_VAR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_TSHELL_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_TSHELL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_TSHELL_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_TSHELL_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_TSHELL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_TSHELL_STRAIN_RATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_TSHELL_HISTORY_VAR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_AXIAL_FORCE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_S_SHEAR_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_T_SHEAR_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_S_BENDING_MOMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_T_BENDING_MOMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_TORSIONAL_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_BEAM_AXIAL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_BEAM_RS_SHEAR_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_BEAM_TR_SHEAR_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_BEAM_AXIAL_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_BEAM_AXIAL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_BEAM_HISTORY_VAR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_STRAIN_RATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_THERMAL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_THICKNESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_THICKNESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_ELEMENT_DEPENDENT_VAR_1,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SHELL_ELEMENT_DEPENDENT_VAR_2,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_HISTORY_VAR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_MX,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_MY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_MXY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_QX,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_QY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_NX,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_NY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_NXY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_HAS_SHELL_INTERNAL_ENERGY_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_RAIDUS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_PRESSURE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_INTERNAL_ENERGY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_STRAIN_RATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_SPH_MASS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_FREQUENCY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_NODE_DISPLACEMENTS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_NODE_VELOCITIES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_NODE_ACCELERATIONS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SOLID_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SOLID_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SOLID_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_TSHELL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_TSHELL_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_TSHELL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_AXIAL_FORCE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_S_SHEAR_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_T_SHEAR_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_S_BENDING_MOMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_T_BENDING_MOMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_TORSIONAL_RESULTANT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_AXIAL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_RS_SHEAR_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_TR_SHEAR_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_AXIAL_PLASTIC_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_BEAM_AXIAL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SHELL_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SHELL_VON_MISES_STRESS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FREQUENCY_HAS_SHELL_STRAIN,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_FTG,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FTG_HAS_SOLID_VARIABLES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FTG_HAS_TSHELL_VARIABLES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FTG_HAS_BEAM_VARIABLES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_FTG_HAS_SHELL_VARIABLES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ACS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_ACOUSTIC_INTENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_NORMAL_VELOCITY_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACS_HAS_NORMAL_VELOCITY_IMAGINARY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ATV,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ATV_HAS_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ATV_HAS_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ATV_HAS_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_EIGV,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_EIGV_HAS_NODE_COORDINATES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_EIGV_HAS_NODE_VELOCITIES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_EIGV_HAS_NODE_ACCELERATIONS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_EIGV_AC,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_EIGV_AC_HAS_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ERP,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ERP_HAS_NORMAL_VELOCITY_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ERP_HAS_NORMAL_VELOCITY_IMAGINARY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ERP_HAS_NORMAL_VELOCITY_ABSOLUTE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ERP_HAS_ACOUSTIC_INTENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ERP_HAS_ACOUSTIC_ERP_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ACP,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACP_HAS_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACP_HAS_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACP_HAS_ACOUSTIC_INTENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACP_HAS_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ACC,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACC_HAS_FIELD_POINT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ACC_HAS_SHELL_VARIABLES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_ALE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_2D_ALE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_HAS_MATERIAL_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_HAS_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_HAS_VOLUME_FRACTION,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_HAS_DOMINANT_MATERIAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_HAS_SPECIES_MASS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_2D_ALE_HAS_DENSITY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_2D_ALE_HAS_VOLUME_FRACTION,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_2D_ALE_HAS_DOMINANT_MATERIAL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_2D_ALE_HAS_SPECIES_MASS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_MS_DATA,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver, ipart
     */
    D3P_MS_DOMAIN_HAS_PART_NAME,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_HAS_PART_MAT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_HAS_PART_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_HAS_NODE_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_HAS_ELEM_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ipart_user or ipart
     */
    D3P_IS_SHELL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ipart_user or ipart
     */
    D3P_IS_SOLID,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ipart_user or ipart
     */
    D3P_IS_TSHELL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ipart_user or ipart
     */
    D3P_IS_BEAM,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ipart_user or ipart
     */
    D3P_IS_SPH,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_IS_COMPLEX_D3SSD,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_NODE_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_NODE_COORDINATES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_NODE_VELOCITIES,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_NODE_ACCELERATIONS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_SEGMENT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_STATES,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: ignore
     */
    D3P_TIMES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ist
     */
    D3P_NEW_GEOM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ist
     */
    D3P_NEW_GEOM_STATE,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3P_GLOBAL_KINETIC_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3P_GLOBAL_INTERNAL_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3P_GLOBAL_TOTAL_ENERGY,

    /**
     * conversion: _D3P_Vector
     * length    : 1
     * parameters: ist
     */
    D3P_GLOBAL_VELOCITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_PARTS,

    /**
     * conversion: int
     * length    : D3P_NUM_PARTS
     * parameters: ignore
     */
    D3P_PART_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_PART_NAME,

    /**
     * conversion: char
     * length    : 80
     * parameters: ipart_user or ipart
     */
    D3P_PART_NAME,

    /**
     * conversion: _D3P_PartTitle
     * length    : D3P_NUM_PART_NAME
     * parameters: ignore
     */
    D3P_PART_NAME_STRUCT,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3P_PART_INTERNAL_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3P_PART_KINETIC_ENERGY,

    /**
     * conversion: _D3P_Vector
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3P_PART_VELOCITY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3P_PART_MASS,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3P_PART_HOURGLASS,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_PART_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_NUM_RIGID_WALL,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, i_rigid_wall
     */
    D3P_RIGID_WALL_FORCE,

    /**
     * conversion: _D3P_Vector
     * length    : 1
     * parameters: ist, i_rigid_wall
     */
    D3P_RIGID_WALL_POSITION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_INITIAL_COORDINATES,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_INITIAL_COORDINATES_DOUBLE,

    /**
     * conversion: int
     * length    : D3P_NUM_NODES
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_IDS,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set, ipt if necessary
                   shell node:
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
                   solid node: ignore
     */
    D3P_NODE_TEMPERATURE,

    /**
     * conversion: double
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set, ipt if necessary
                   shell node:
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
                   solid node: ignore
     */
    D3P_NODE_TEMPERATURE_DOUBLE,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_HEAT_FLUX,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_MASS_SCALING,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_TEMPERATURE_DIVIDE_TIME,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_RESIDUAL_FORCE,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_RESIDUAL_MOMENT,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_PENETRATION,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_RELATIVE_PENETRATION,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_CONTACT_ENERGY_DENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_KINETIC_ENERGY_DENSITY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_DISPLACEMENTS,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_NODE_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_SOLID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SOLID_PART,

    /**
     * conversion: _D3P_Solid
     * length    : D3P_NUM_SOLID
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : D3P_NUM_SOLID
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_IDS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_SIGNED_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_1ST_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_2ND_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_3RD_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_TRESCA_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_SIGNED_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_MAX_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_2ND_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_MIN_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_TRESCA_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_PLASTIC_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_THERMAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ihv, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_HISTORY_VAR,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_SOLID_MAXINT,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_SOLID_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_SOLID_HISTORY_VAR_NUM,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_ELEMENT_CENTROID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SOLID20,

    /**
     * conversion: D3P_SolidExtra20
     * length    : D3P_NUM_SOLID20
     * parameters: ist
     */
    D3P_SOLID20_CONNECTIVITY_EXTRA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SOLID27,

    /**
     * conversion: D3P_SolidExtra27
     * length    : D3P_NUM_SOLID27
     * parameters: ist
     */
    D3P_SOLID27_CONNECTIVITY_EXTRA,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_INFINITESIMAL_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_GREEN_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_ALMANSI_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_STRAIN_RATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_TSHELL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_TSHELL_PART,

    /**
     * conversion: _D3P_Tshell
     * length    : D3P_NUM_TSHELL
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : D3P_NUM_TSHELL
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_IDS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_SIGNED_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_1ST_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_2ND_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_3RD_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_TRESCA_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_SIGNED_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_MAX_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_2ND_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_MIN_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_TSHELL_TRESCA_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ihv, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_HISTORY_VAR,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_TSHELL_MAXINT,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_TSHELL_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_TSHELL_HISTORY_VAR_NUM,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_ELEMENT_CENTROID,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_INFINITESIMAL_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_GREEN_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_ALMANSI_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_STRAIN_RATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_BEAM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_BEAM_PART,

    /**
     * conversion: _D3P_Beam
     * length    : D3P_NUM_BEAM
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_CONNECTIVITY_THIRD_MAT,

    /**
     * conversion: int
     * length    : D3P_NUM_BEAM
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_IDS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_AXIAL_FORCE,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_S_SHEAR_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_T_SHEAR_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_S_BENDING_MOMENT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_T_BENDING_MOMENT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_TORSIONAL_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_AXIAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_RS_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_TR_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_AXIAL_PLASTIC_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_AXIAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ihv, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_HISTORY_VAR,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_INTERNAL_ENERGY_DENSITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_BEAM_MAXINT,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_BEAM_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_BEAM_HISTORY_VAR_NUM,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_ELEMENT_CENTROID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_SHELL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SHELL_PART,

    /**
     * conversion: _D3P_Shell
     * length    : D3P_NUM_SHELL
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : D3P_NUM_SHELL
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_IDS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_SIGNED_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_1ST_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_2ND_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_3RD_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_TRESCA_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_EFFECTIVE_PLASTIC_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_SIGNED_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_MAX_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_2ND_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_MIN_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_TRESCA_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part, ipartset_user if by part set
                   ipt = 0: middle
                   ipt = 1: inner
                   ipt = 2: outer
     */
    D3P_SHELL_PLASTIC_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_THERMAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_THICKNESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_ELEMENT_DEPENDENT_VAR_1,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_ELEMENT_DEPENDENT_VAR_2,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ihv, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_HISTORY_VAR,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_SHELL_MAXINT,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_MX,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_MY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_MXY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_QX,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_QY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_NX,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_NY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_NXY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_INTERNAL_ENERGY_DENSITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_SHELL_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_SHELL_HISTORY_VAR_NUM,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_ELEMENT_CENTROID,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_INFINITESIMAL_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_GREEN_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_ALMANSI_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_STRAIN_RATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ist
     */
    D3P_HAS_DELETION,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID + D3P_NUM_TSHELL + D3P_NUM_SHELL + D3P_NUM_BEAM
     * parameters: ist
     */
    D3P_ALL_DELETION,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SOLID_DELETION,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_TSHELL_DELETION,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SHELL_DELETION,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_BEAM_DELETION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_NUM_SPH,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SPH_PART,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SPH_VARS,

    /**
     * conversion: _D3P_Sph
     * length    : D3P_NUM_SPH
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_NODE_MAT,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_RADIUS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_PRESSURE,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_PLASTIC_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_DENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_INTERNAL_ENERGY,

    /**
     * conversion: int
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_NUMBER_OF_PARTICLE_NEIGHBORS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_STRAIN_RATE,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_MASS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_SIGNED_VON_MISES_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_SIGNED_VON_MISES_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_1ST_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_2ND_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_3RD_PRINCIPAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_TRESCA_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_MAX_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_2ND_PRINCIPAL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_SPH_MIN_PRINCIPAL_STRAIN,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3P_SPH_INTERNAL_ID,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_DES_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_DES_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_PART_IN_GEOM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_ELEM_IN_GEOM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_PART_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_ELEM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_PART_VAR_IN_GEOM,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_NUM_DES_PART_VAR_IN_GEOM
     * parameters: ides if necessary
     */
    D3P_DES_PART_VAR_LIST_IN_GEOM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_ELEM_VAR_IN_GEOM,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_NUM_DES_ELEM_VAR_IN_GEOM
     * parameters: ides if necessary
     */
    D3P_DES_ELEM_VAR_LIST_IN_GEOM,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_PART_VAR_IN_STATE,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_NUM_DES_PART_VAR_IN_STATE
     * parameters: ides if necessary
     */
    D3P_DES_PART_VAR_LIST_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_ELEM_VAR_IN_STATE,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_NUM_DES_ELEM_VAR_IN_STATE
     * parameters: ides if necessary
     */
    D3P_DES_ELEM_VAR_LIST_IN_STATE,

    /**
     * conversion: _D3P_DES
     * length    : D3P_NUM_DES_ELEM_IN_GEOM
     * parameters: ides if necessary
     */
    D3P_DES_NODAL_MAT_RADIUS_MASS_INERTIA,

    /**
     * conversion: int/float..depends
     * length    : D3P_NUM_DES_ELEM_IN_STATE
     * parameters: var_name, ist, ides if necessary
     */
    D3P_DES_DATA_IN_STATE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_CPM_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_CPM_NUM_AIRBAGS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_CPM_NUM_PARTICLES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_CPM_NUM_GEOM_VAR,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_CPM_NUM_GEOM_VAR
     * parameters: ignore
     */
    D3P_CPM_GEOM_VAR_LIST,

    /**
     * conversion: int/float...depends
     * length    : D3P_CPM_NUM_AIRBAGS
     * parameters: var_name
     */
    D3P_CPM_GEOM_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_CPM_NUM_STATE_VAR,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_CPM_NUM_STATE_VAR
     * parameters: ignore
     */
    D3P_CPM_STATE_VAR_LIST,

    /**
     * conversion: int/float...depends
     * length    : D3P_CPM_NUM_PARTICLES
     * parameters: var_name, ist
     */
    D3P_CPM_STATE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_CPM_NUM_STATE_GEOM_VAR,

    /**
     * conversion: _D3P_VAR
     * length    : D3P_CPM_NUM_STATE_GEOM_VAR
     * parameters: ignore
     */
    D3P_CPM_STATE_GEOM_VAR_LIST,

    /**
     * conversion: int/float...depends
     * length    : D3P_CPM_NUM_AIRBAGS
     * parameters: var_name, ist
     */
    D3P_CPM_STATE_GEOM_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_NODES_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SEGMENTS_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SURFACES_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_MOTION_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : D3P_NUM_NODES_IN_RIGID_ROAD_SURFACE
     * parameters: ignore
     */
    D3P_NODE_IDS_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES_IN_RIGID_ROAD_SURFACE
     * parameters: ignore
     */
    D3P_NODE_COORDINATES_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : D3P_NUM_SURFACES_IN_RIGID_ROAD_SURFACE
     * parameters: ignore
     */
    D3P_SURFACE_IDS_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: int
     * length    : 1
     * parameters: isurface
     */
    D3P_NUM_SEGMENTS_OF_SURFACE_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: D3P_SegmentOfRoadSurf
     * length    : D3P_NUM_SEGMENTS_OF_SURFACE_IN_RIGID_ROAD_SURFACE
     * parameters: isurface
     */
    D3P_SEGMENT_CONNECTIVITY_OF_SURFACE_IN_RIGID_ROAD_SURFACE,

    /**
     * conversion: float
     * length    : D3P_MOTION_IN_RIGID_ROAD_SURFACE
     * parameters: ignore
     */
    D3P_RGSURF_STATE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_RIGID_BODY_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : 1
     * parameters: i_rigid_body, ist if adaptive model
     */
    D3P_NUM_NODES_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_NUM_ACTIVE_NODE_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : D3P_NUM_RIGID_BODY_IN_RIGID_BODY_MOTION
     * parameters: ignore
     */
    D3P_PART_INTERNAL_IDS_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : D3P_NUM_NODES_IN_RIGID_BODY_MOTION
     * parameters: i_rigid_body, ist if adaptive model
     */
    D3P_NODE_INTERNAL_IDS_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : D3P_NUM_ACTIVE_NODE_IN_RIGID_BODY_MOTION
     * parameters: ignore, ist if adaptive model
     */
    D3P_ACTIVE_NODE_INTERNAL_IDS_IN_RIGID_BODY_MOTION,

    /**
     * conversion: D3P_RBodyMotion
     * length    : D3P_NUM_RIGID_BODY_IN_RIGID_BODY_MOTION
     * parameters: ist
     */
    D3P_RIGID_BODY_STATE_DATA_IN_RIGID_BODY_MOTION,

    /**
     * conversion: D3P_RBodyMotionDouble
     * length    : D3P_NUM_RIGID_BODY_IN_RIGID_BODY_MOTION
     * parameters: ist
     */
    D3P_RIGID_BODY_STATE_DATA_DOUBLE_IN_RIGID_BODY_MOTION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_MS_NUM_DOMAINS,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_ID,

    /**
     * conversion: char[]
     * length    : 80
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_NAME,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_FOLLOW_SURFACE_METHOD,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_SOLID,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_SHELL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_BEAM,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_TSHELL,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_NUM_PART,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_PART_NUM
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_PART_MAT,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_PART_NUM
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_PART_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_IS_ADAPTIVE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NUM_NODE,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_NUM_NODE
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NODE_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NUM_NODE_ON_SURFACE,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_NUM_NODE_ON_SURFACE
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NODE_IDS_ON_SURFACE,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_MS_DOMAIN_NUM_NODE
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NODE_COORDINATES,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_NUM_ELEM,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_NUM_ELEM
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_ELEM_IDS,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_DATA_IS_ON_STRUCTURE_ELEMENT,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_DATA_IS_ON_STRUCTURE_NODE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_DATA_IS_ON_MS_NODE,

    /**
     * conversion: bool
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_DATA_IS_ON_MS_ELEMENT,

    /**
     * conversion: _D3P_Solid
     * length    : D3P_MS_DOMAIN_NUM_ELEM
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_SOLID_CONNECTIVITY_MAT,

    /**
     * conversion: _D3P_Shell
     * length    : D3P_MS_DOMAIN_NUM_ELEM
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_SHELL_CONNECTIVITY_MAT,

    /**
     * conversion: _D3P_Beam
     * length    : D3P_MS_DOMAIN_NUM_ELEM
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_BEAM_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_VAR_NUM,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_VAR_NUM
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_VARS_LIST,

    /**
     * conversion: char
     * length    : 80
     * parameters: id_var_multisolver
     */
    D3P_MS_VAR_NAME,

    /**
     * conversion: bool
     * length    : 1
     * parameters: id_var_multisolver
     */
    D3P_MS_VAR_IS_VECTOR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: id_var_multisolver
     */
    D3P_MS_VAR_IS_SCALAR,

    /**
     * conversion: bool
     * length    : 1
     * parameters: id_var_multisolver
     */
    D3P_MS_VAR_IS_TENSOR,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist if adaptive model
     */
    D3P_MS_DOMAIN_VAR_LENGTH,

    /**
     * conversion: float or D3P_Vector or D3P_Tensor
     * length    : D3P_MS_DOMAIN_VAR_LENGTH
     * parameters: index_multisolver, ist, id_var_multisolver
     */
    D3P_MS_DOMAIN_DATA_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_NODE_NUM_ONSURFACE_IN_STATE,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_NODE_NUM_ONSURFACE_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_SURFACE_IDS_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ELEM_NUM_IN_STATE,

    /**
     * conversion: _D3P_Solid
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_SOLID_CONNECTIVITY_MAT_IN_STATE,

    /**
     * conversion: _D3P_Shell
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_SHELL_CONNECTIVITY_MAT_IN_STATE,

    /**
     * conversion: _D3P_Beam
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_BEAM_CONNECTIVITY_MAT_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_NODE_NUM_IN_STATE,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_MS_DOMAIN_NODE_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_COORD_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ENERGY_VAR_NUM,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_ENERGY_VAR_NUM
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ENERGY_VARS_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_TETRAHEDRAL_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_PYRAMID_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_WEDGE_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_TRIA_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_QUAD_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_HEXA_NUM_IN_STATE,

    /**
     * conversion: D3P_SOLIDTET
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_TETRA_IN_STATE,

    /**
     * conversion: D3P_OLDSOLIDELE
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_MAT_IN_STATE,

    /**
     * conversion: D3P_SEGMENT2
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_BEAM_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_FACE_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_PYRAMID_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_PYRAM_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_WEDGE_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_WEDGE_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_HEXA_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_HEXA_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_SOLVER_FLAG,

    /**
     * conversion: float
     * length    : D3P_MS_DOMAIN_VAR_LENGTH
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_PARTICLE_LIST,

    /**
     * conversion: D3P_TRIAELE
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_CONNECTIVITY_TRIA_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_ORIG_SHELL_CONNECTIVITY_IN_STATE,

    /**
     * conversion: D3P_SOLIDFACE
     * length    : D3P_MS_DOMAIN_QUAD_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_QUAD_CONNECTIVITY_MAT_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ENERGY_GROUPS_NUM,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_ENERGY_GROUPS_NUM
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ENERGY_GROUP_NODES,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_INTEGRATION_POINTS,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_EDGES_NUM,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_EDGE_DOMAIN_NUM,

    /**
     * conversion: int
     * length    : NUMBER_OF_EDGE_DOMAIN
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_EDGES_PER_DOMAIN_NUMS,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_EDGE_DOMAIN_NUM accumulate D3P_MS_DOMAIN_EDGES_PER_DOMAIN_NUMS
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_NODE_EDGE_CONNECTIVITY,

    /**
     * conversion: int
     * length    : accumulate D3P_MS_DOMAIN_EDGES_PER_DOMAIN_NUMS
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_EDGE_DOMAIN_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver
     */
    D3P_MS_DOMAIN_PART_NUM,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_PART_NUM+D3P_MS_DOMAIN_PART_NUM
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_PART_LIST,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_VAR_LENGTH
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_NODE_LIST,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_NODE_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_NODE_USER_ID,

    /**
     * conversion: int
     * length    : D3P_MS_DOMAIN_ELEM_NUM_IN_STATE
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_ELEM_USER_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: index_multisolver, ist
     */
    D3P_MS_DOMAIN_SURFACE_NODE_NUM_IN_STATE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_MS_NUM_PART_TITLE,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: ignore
     */
    D3P_GLOBAL_KINETIC_ENERGY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: ignore
     */
    D3P_GLOBAL_INTERNAL_ENERGY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: ignore
     */
    D3P_GLOBAL_TOTAL_ENERGY_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: ignore
     */
    D3P_GLOBAL_VELOCITY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt if necessary
                   shell node:
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
                   solid node: ignore ipt
     */
    D3P_NODE_TEMPERATURE_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3P_SOLID_EFFECTIVE_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt if necessary, ihv
     */
    D3P_SOLID_HISTORY_VAR_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_TSHELL_EFFECTIVE_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt, ihv
     */
    D3P_TSHELL_HISTORY_VAR_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_AXIAL_FORCE_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_S_SHEAR_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_T_SHEAR_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_S_BENDING_MOMENT_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_T_BENDING_MOMENT_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_TORSIONAL_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_BEAM_AXIAL_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_BEAM_RS_SHEAR_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_BEAM_TR_SHEAR_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_BEAM_AXIAL_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_BEAM_AXIAL_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt, ihv
     */
    D3P_BEAM_HISTORY_VAR_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_SHELL_EFFECTIVE_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_THICKNESS_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_ELEMENT_DEPENDENT_VAR_1_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_ELEMENT_DEPENDENT_VAR_2_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt, ihv
     */
    D3P_SHELL_HISTORY_VAR_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_MX_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_MY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_MXY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_QX_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_QY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_NX_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_NY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_NXY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_INTERNAL_ENERGY_DENSITY_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SOLID_DELETION_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_TSHELL_DELETION_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_DELETION_HISTORY,

    /**
     * conversion: float
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_DELETION_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_NODE_HEAT_FLUX_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_NODE_COORDINATES_HISTORY,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_NODE_COORDINATES_DOUBLE_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_NODE_VELOCITIES_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_NODE_ACCELERATIONS_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SOLID_ELEMENT_CENTROID_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_TSHELL_ELEMENT_CENTROID_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_BEAM_ELEMENT_CENTROID_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_ELEMENT_CENTROID_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3P_SOLID_STRESS_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3P_SOLID_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SOLID_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SOLID_THERMAL_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_TSHELL_STRESS_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
     */
    D3P_TSHELL_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
     */
    D3P_SHELL_STRESS_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
     */
    D3P_SHELL_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser, ipt
                   ipt = 0, middle
                   ipt = 1, inner
                   ipt = 2, outer
     */
    D3P_SHELL_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SHELL_THERMAL_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SPH_STRESS_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SPH_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_STATES
     * parameters: iuser
     */
    D3P_SPH_STRAIN_RATE_HISTORY,

    /**
     * conversion: ndarray
     * length    : (D3P_NUM_NODES, 4)
     * parameters: ist
     */
    D3P_NODE_ID_COORDINATES,

    /**
     * conversion: ndarray
     * length    : (D3P_NUM_SHELL, 6)
     * parameters: ignore, ist if adaptive model
     */
    D3P_SHELL_ID_CONNECTIVITY_MAT,

    /**
     * conversion: ndarray
     * length    : (D3P_NUM_SOLID, 10)
     * parameters: ignore, ist if adaptive model
     */
    D3P_SOLID_ID_CONNECTIVITY_MAT,

    /**
     * conversion: ndarray
     * length    : (D3P_NUM_TSHELL, 10)
     * parameters: ignore, ist if adaptive model
     */
    D3P_TSHELL_ID_CONNECTIVITY_MAT,

    /**
     * conversion: ndarray
     * length    : (D3P_NUM_BEAM, 4)
     * parameters: ignore, ist if adaptive model
     */
    D3P_BEAM_ID_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    INF_NUM_STATES,

    /**
     * conversion: float
     * length    : INF_NUM_STATES
     * parameters: ignore
     */
    INF_TIMES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    INF_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    INF_NODE_INITIAL_COORDINATES,

    /**
     * conversion: int
     * length    : INF_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    INF_NODE_IDS,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : INF_NUM_NODES
     * parameters: ist
     */
    INF_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    INF_NUM_SEGMENTS,

    /**
     * conversion: _D3P_Shell
     * length    : INF_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    INF_SEGMENT_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : INF_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    INF_SEGMENT_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    INF_NUM_VAR,

    /**
     * conversion: int
     * length    : INF_NUM_VAR
     * parameters: ignore
     */
    INF_VAR_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    INF_NUM_CHARACTERS_OF_VAR_NAME,

    /**
     * conversion: char
     * length    : INF_NUM_CHARACTERS_OF_VAR_NAME
     * parameters: index_var_inf
     */
    INF_VAR_NAME,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: index_var_inf, ist
     */
    INF_VAR_VALUE,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_INTERFACE_PRESSURE,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_INTERFACE_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_R_INTERFACE_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_S_INTERFACE_SHEAR_STRESS,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N1_INTERFACE_FORCE,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N2_INTERFACE_FORCE,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N3_INTERFACE_FORCE,

    /**
     * conversion: _D3P_Vector
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N4_INTERFACE_FORCE,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N1_CONTACT_GAP,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N2_CONTACT_GAP,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N3_CONTACT_GAP,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_N4_CONTACT_GAP,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENTS
     * parameters: ist
     */
    INF_SURFACE_ENERGY_DENSITY,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    INF_NUM_SEGMENT_STATE_DATA,

    /**
     * conversion: float
     * length    : INF_NUM_SEGMENT_STATE_DATA
     * parameters: ist
     */
    INF_SEGMENT_STATE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    FSIFOR_NUM_STATES,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_STATES
     * parameters: ignore
     */
    FSIFOR_TIMES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_NODE_INITIAL_COORDINATES,

    /**
     * conversion: int
     * length    : FSIFOR_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_NODE_IDS,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR_NUM_NODES
     * parameters: ist
     */
    FSIFOR_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_NUM_SEGMENTS,

    /**
     * conversion: _D3P_Shell
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_SEGMENT_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR_SEGMENT_IDS,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_NORMAL_INTERFACE_PRESSURE,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_X_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_Y_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_Z_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_RELATIVE_INTERFACE_VELOCITY,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_X_INTERFACE_VELOCITY,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_Y_INTERFACE_VELOCITY,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR_Z_INTERFACE_VELOCITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    BLSTFOR_NUM_STATES,

    /**
     * conversion: float
     * length    : FSIFOR_NUM_STATES
     * parameters: ignore
     */
    BLSTFOR_TIMES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : BLSTFOR_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_NODE_INITIAL_COORDINATES,

    /**
     * conversion: int
     * length    : BLSTFOR_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_NODE_IDS,

    /**
     * conversion: _D3P_Vector
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : BLSTFOR_NUM_NODES
     * parameters: ist
     */
    BLSTFOR_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_NUM_SEGMENTS,

    /**
     * conversion: _D3P_Shell
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_SEGMENT_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    BLSTFOR_SEGMENT_IDS,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_EFFECTIVE_PRESSURE,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_WAVE_INDEX,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_INCIDENT_PRESSURE,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_MASS_DENSITY_OF_AIR,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_X_VELOCITY_OF_BLAST_WIND,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_Y_VELOCITY_OF_BLAST_WIND,

    /**
     * conversion: float
     * length    : BLSTFOR_NUM_SEGMENTS
     * parameters: ist
     */
    BLSTFOR_Z_VELOCITY_OF_BLAST_WIND,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    FSIFOR2_NUM_STATES,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_STATES
     * parameters: ignore
     */
    FSIFOR2_TIMES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR2_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_NODE_INITIAL_COORDINATES,

    /**
     * conversion: int
     * length    : FSIFOR2_NUM_NODES
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_NODE_IDS,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : FSIFOR2_NUM_NODES
     * parameters: ist
     */
    FSIFOR2_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_NUM_SEGMENTS,

    /**
     * conversion: _D3P_Shell
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_SEGMENT_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ignore, ist if adaptive model
     */
    FSIFOR2_SEGMENT_IDS,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_PRESSURE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_M_STEM,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_INCI_PRESSURE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_TEMPERATURE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_RESULTANT_INTERFACE_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_NORMAL_INTERFACE_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_SURFACE_INTERFACE_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_X_SURFACE_SHEAR_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_Y_SURFACE_SHEAR_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_Z_SURFACE_SHEAR_FORCE,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_VX_P,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_VY_P,

    /**
     * conversion: float
     * length    : FSIFOR2_NUM_SEGMENTS
     * parameters: ist
     */
    FSIFOR2_VZ_P,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_FREQUENCY,

    /**
     * conversion: float
     * length    : D3P_NUM_FREQUENCY
     * parameters: ignore
     */
    D3P_FREQUENCIES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_DISPLACEMENTS,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_DISPLACEMENTS_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_NUM_NODES
     * parameters: ist, option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SOLID_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SOLID_VON_MISES_STRESS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SOLID_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_TSHELL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_TSHELL_VON_MISES_STRESS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
                   ipt = 0: mean
                   ipt = 1: inner
                   ipt = 2: outer
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_TSHELL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_AXIAL_FORCE,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_S_SHEAR_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_T_SHEAR_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_S_BENDING_MOMENT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_T_BENDING_MOMENT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_TORSIONAL_RESULTANT,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_AXIAL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_RS_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_TR_SHEAR_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_AXIAL_PLASTIC_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_BEAM_AXIAL_STRAIN,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SHELL_STRESS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt if necessary, ipart or ipart_user if by part
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SHELL_VON_MISES_STRESS,

    /**
     * conversion: _D3P_Tensor
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
                   ipt = 0: mean
                   ipt = 1: inner
                   ipt = 2: outer
				   option(for complex version d3ssd: 1-amplitude, 2-phase angle)
     */
    D3P_FREQUENCY_SHELL_STRAIN,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_CUMULATIVE_DAMAGE_RATIO,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_EXPECTED_FATIGUE_LIFE,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_ZERO_CROSSING_FREQUENCY,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_PEAK_CROSSING_FREQUENCIES,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_IRREGULARITY_FACTORS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SOLID_EXPECTED_FATIGUE_CYCLES,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_CUMULATIVE_DAMAGE_RATIO,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_EXPECTED_FATIGUE_LIFE,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_ZERO_CROSSING_FREQUENCY,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_PEAK_CROSSING_FREQUENCIES,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_IRREGULARITY_FACTORS,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_TSHELL_EXPECTED_FATIGUE_CYCLES,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_CUMULATIVE_DAMAGE_RATIO,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_EXPECTED_FATIGUE_LIFE,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_ZERO_CROSSING_FREQUENCY,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_PEAK_CROSSING_FREQUENCIES,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_IRREGULARITY_FACTORS,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_BEAM_EXPECTED_FATIGUE_CYCLES,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_CUMULATIVE_DAMAGE_RATIO,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_EXPECTED_FATIGUE_LIFE,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_ZERO_CROSSING_FREQUENCY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_PEAK_CROSSING_FREQUENCIES,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_IRREGULARITY_FACTORS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, ipt, ipart or ipart_user if by part
     */
    D3P_FTG_SHELL_EXPECTED_FATIGUE_CYCLES,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_ACOUSTIC_INTENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_NORMAL_VELOCITY_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ignore
     */
    D3P_ACS_NORMAL_VELOCITY_IMAGINARY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_ATV_NUM_FIELD_POINT,

    /**
     * conversion: int
     * length    : D3P_ATV_NUM_FIELD_POINT
     * parameters: ignore
     */
    D3P_ATV_FIELD_POINTS,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ifieldpoint
     */
    D3P_ATV_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ifieldpoint
     */
    D3P_ATV_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist, ifieldpoint
     */
    D3P_ATV_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NUM_NODES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_COORDINATES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_VELOCITIES,

    /**
     * conversion: _D3P_Vector
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_ACCELERATIONS,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_COORDINATES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_VELOCITIES_DOUBLE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3P_EIGV_NUM_NODES
     * parameters: ist, ipart or ipart_user if by part, ipartset_user if by part set
     */
    D3P_EIGV_NODE_ACCELERATIONS_DOUBLE,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_EIGV_AC_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ERP_NORMAL_VELOCITY_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ERP_NORMAL_VELOCITY_IMAGINARY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ERP_NORMAL_VELOCITY_ABSOLUTE,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ERP_ACOUSTIC_INTENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ERP_ACOUSTIC_ERP_DENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ACP_ACOUSTIC_PRESSURE_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ACP_ACOUSTIC_PRESSURE_IMAGINARY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ACP_ACOUSTIC_INTENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_NODES
     * parameters: ist
     */
    D3P_ACP_SOUND_PRESSURE_LEVEL_dB,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_ACC_NUM_FIELD_POINT,

    /**
     * conversion: int
     * length    : D3P_ACC_NUM_FIELD_POINT
     * parameters: ignore
     */
    D3P_ACC_FIELD_POINTS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL(only support shell elements)
     * parameters: ist, ifieldpoint, ipart or ipart_user if by part
     */
    D3P_ACC_SHELL_ACOUSTIC_PRESSURE_CONTRIBUTION_REAL,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL(only support shell elements)
     * parameters: ist, ifieldpoint, ipart or ipart_user if by part
     */
    D3P_ACC_SHELL_ACOUSTIC_PRESSURE_CONTRIBUTION_IMAGINARY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL(only support shell elements)
     * parameters: ist, ifieldpoint, ipart or ipart_user if by part
     */
    D3P_ACC_SHELL_ACOUSTIC_PRESSURE_CONTRIBUTION_PERCENTAGE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_NUM_FLUID_GROUP,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_ALE_NUM_FLUID_PART,

    /**
     * conversion: int
     * length    : D3P_ALE_NUM_FLUID_PART
     * parameters: ignore
     */
    D3P_ALE_MATERIAL_IDS,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist
     */
    D3P_ALE_DENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, id_fluid_group (from 1 to D3P_ALE_NUM_FLUID_GROUP)
     */
    D3P_ALE_VOLUME_FRACTION,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist
     */
    D3P_ALE_DOMINANT_MATERIAL,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID
     * parameters: ist, id_fluid_group (from 1 to D3P_ALE_NUM_FLUID_GROUP)
     */
    D3P_ALE_SPECIES_MASS,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist
     */
    D3P_2D_ALE_DENSITY,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, id_fluid_group (from 1 to D3P_ALE_NUM_FLUID_GROUP)
     */
    D3P_2D_ALE_VOLUME_FRACTION,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist
     */
    D3P_2D_ALE_DOMINANT_MATERIAL,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL
     * parameters: ist, id_fluid_group (from 1 to D3P_ALE_NUM_FLUID_GROUP)
     */
    D3P_2D_ALE_SPECIES_MASS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_STATES,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: ignore
     */
    D3T_TIMES,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3T_GLOBAL_KINETIC_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3T_GLOBAL_INTERNAL_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist
     */
    D3T_GLOBAL_TOTAL_ENERGY,

    /**
     * conversion: _D3P_Vector
     * length    : 1
     * parameters: ist
     */
    D3T_GLOBAL_VELOCITY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_PARTS,

    /**
     * conversion: int
     * length    : D3T_NUM_PARTS
     * parameters: ignore
     */
    D3T_PART_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_PART_NAME,

    /**
     * conversion: char
     * length    : 80
     * parameters: ipart_user or ipart
     */
    D3T_PART_NAME,

    /**
     * conversion: _D3P_PartTitle
     * length    : D3T_NUM_PART_NAME
     * parameters: ignore
     */
    D3T_PART_NAME_STRUCT,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3T_PART_INTERNAL_ENERGY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3T_PART_KINETIC_ENERGY,

    /**
     * conversion: _D3P_Vector
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3T_PART_VELOCITY,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3T_PART_MASS,

    /**
     * conversion: float
     * length    : 1
     * parameters: ist, ipart_user or ipart
     */
    D3T_PART_HOURGLASS,

    /**
     * conversion: int
     * length    : 1
     * parameters: iuser
     */
    D3T_PART_INTERNAL_ID,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_NODES,

    /**
     * conversion: int
     * length    : D3T_NUM_NODES
     * parameters: ignore
     */
    D3T_NODE_IDS,

    /**
     * conversion: _D3P_Vector
     * length    : D3T_NUM_NODES
     * parameters: ignore
     */
    D3T_NODE_INITIAL_COORDINATES,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_NODES_PLOT,

    /**
     * conversion: int
     * length    : D3T_NUM_NODES_PLOT
     * parameters: ignore
     */
    D3T_NODE_IDS_PLOT,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_NODE_TEMPERATURE_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_NODE_COORDINATES_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_NODE_VELOCITIES_HISTORY,

    /**
     * conversion: _D3P_Vector
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_NODE_ACCELERATIONS_HISTORY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_SOLID,

    /**
     * conversion: _D3P_Solid
     * length    : D3T_NUM_SOLID
     * parameters: ignore
     */
    D3T_SOLID_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : D3T_NUM_SOLID
     * parameters: ignore
     */
    D3T_SOLID_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_SOLID_PLOT,

    /**
     * conversion: int
     * length    : D3T_NUM_SOLID_PLOT
     * parameters: ignore
     */
    D3T_SOLID_IDS_PLOT,

    /**
     * conversion: _D3P_Tensor
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3T_SOLID_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3T_SOLID_VON_MISES_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt if necessary
     */
    D3T_SOLID_EFFECTIVE_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SOLID_STRAIN_HISTORY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_SHELL,

    /**
     * conversion: _D3P_Shell
     * length    : D3T_NUM_SHELL
     * parameters: ignore
     */
    D3T_SHELL_CONNECTIVITY_MAT,

    /**
     * conversion: int
     * length    : D3T_NUM_SHELL
     * parameters: ignore
     */
    D3T_SHELL_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_SHELL_PLOT,

    /**
     * conversion: int
     * length    : D3T_NUM_SHELL_PLOT
     * parameters: ignore
     */
    D3T_SHELL_IDS_PLOT,

    /**
     * conversion: _D3P_Tensor
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_SHELL_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_SHELL_VON_MISES_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_SHELL_EFFECTIVE_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: _D3P_Tensor
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_SHELL_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_MX_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_MY_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_MXY_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_QX_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_QY_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_NX_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_NY_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_SHELL_NXY_HISTORY,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_BEAM,

    /**
     * conversion: _D3P_Beam
     * length    : D3T_NUM_BEAM
     * parameters: ignore
     */
    D3T_BEAM_CONNECTIVITY_THIRD_MAT,

    /**
     * conversion: int
     * length    : D3T_NUM_BEAM
     * parameters: ignore
     */
    D3T_BEAM_IDS,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3T_NUM_BEAM_PLOT,

    /**
     * conversion: int
     * length    : D3T_NUM_BEAM_PLOT
     * parameters: ignore
     */
    D3T_BEAM_IDS_PLOT,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_AXIAL_FORCE_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_S_SHEAR_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_T_SHEAR_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_S_BENDING_MOMENT_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_T_BENDING_MOMENT_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser
     */
    D3T_BEAM_TORSIONAL_RESULTANT_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_BEAM_AXIAL_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_BEAM_RS_SHEAR_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_BEAM_TR_SHEAR_STRESS_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_BEAM_AXIAL_PLASTIC_STRAIN_HISTORY,

    /**
     * conversion: float
     * length    : D3T_NUM_STATES
     * parameters: iuser, ipt
     */
    D3T_BEAM_AXIAL_STRAIN_HISTORY,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_PROPERTY,

    /**
     * conversion: D3P_Control
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_CONTROL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore, ist if adaptive model
     */
    D3P_NUM_EXTRA_CONTROL,

    /**
     * conversion: int
     * length    : D3P_NUM_EXTRA_CONTROL
     * parameters: ignore, ist if adaptive model
     */
    D3P_EXTRA_CONTROL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_HIGHER_ORDER_ELEMENT_PART_VERSION,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_HIGHER_ORDER_ELEMENT_PART,

    /**
     * conversion: D3P_HELM_PART_DATE
     * length    : D3P_NUM_HIGHER_ORDER_ELEMENT_PART
     * parameters: ignore
     */
    D3P_HIGHER_ORDER_ELEMENT_PART_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_MATERIAL_TYPE,

    /**
     * conversion: int
     * length    : D3P_NUM_MATERIAL_TYPE
     * parameters: ignore
     */
    D3P_MATERIAL_TYPE,

    /**
     * conversion: int
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_GLOBAL_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_GLOBAL_STATE_DATA
     * parameters: ist
     */
    D3P_GLOBAL_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SOLID_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID_STATE_DATA
     * parameters: ist
     */
    D3P_SOLID_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SOLID_THERMAL_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_SOLID_THERMAL_STATE_DATA
     * parameters: ist
     */
    D3P_SOLID_THERMAL_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_TSHELL_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_TSHELL_STATE_DATA
     * parameters: ist
     */
    D3P_TSHELL_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_BEAM_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_BEAM_STATE_DATA
     * parameters: ist
     */
    D3P_BEAM_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SHELL_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_SHELL_STATE_DATA
     * parameters: ist
     */
    D3P_SHELL_STATE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3P_NUM_SPH_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_SPH_STATE_DATA
     * parameters: ist
     */
    D3P_SPH_STATE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_SPH_VARS_LIST,

    /**
     * conversion: int
     * length    : D3P_NUM_SPH_VARS_LIST
     * parameters: ignore
     */
    D3P_SPH_VARS_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_DES_EXTENDED_CONTROL,

    /**
     * conversion: int
     * length    : D3P_NUM_DES_EXTENDED_CONTROL
     * parameters: ignore
     */
    D3P_DES_EXTENDED_CONTROL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_DES_VAR_TYPE_LIST,

    /**
     * conversion: int
     * length    : D3P_NUM_DES_VAR_TYPE_LIST
     * parameters: ignore
     */
    D3P_DES_VAR_TYPE_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_DES_VAR_NAME_LIST,

    /**
     * conversion: int
     * length    : D3P_NUM_DES_VAR_NAME_LIST
     * parameters: ignore
     */
    D3P_DES_VAR_NAME_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: ides if necessary
     */
    D3P_NUM_DES_STATE_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_DES_STATE_DATA
     * parameters: ist, ides if necessary
     */
    D3P_DES_STATE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_CPM_GEOM_ALL_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_CPM_GEOM_ALL_DATA
     * parameters: ignore, ist if adaptive model
     */
    D3P_CPM_GEOM_ALL_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_CPM_STATE_ALL_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_CPM_STATE_ALL_DATA
     * parameters: ist
     */
    D3P_CPM_STATE_ALL_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_CPM_STATE_GEOM_ALL_DATA,

    /**
     * conversion: float
     * length    : D3P_NUM_CPM_STATE_GEOM_DATA
     * parameters: ist
     */
    D3P_CPM_STATE_GEOM_ALL_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_PART_TREE_VARS_LIST,

    /**
     * conversion: int
     * length    : D3P_NUM_PART_TREE_VARS_LIST
     * parameters: ignore
     */
    D3P_PART_TREE_VARS_LIST,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_PART_TREE_DATA,

    /**
     * conversion: int
     * length    : D3P_NUM_PART_TREE_DATA
     * parameters: ignore
     */
    D3P_PART_TREE_DATA,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_USER_NUMBER_ALL_DATA,

    /**
     * conversion: char
     * length    : D3P_NUM_USER_NUMBER_ALL_DATA
     * parameters: ignore, ist if adaptive model
     */
    D3P_USER_NUMBER_ALL_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3P_NUM_USER_NUMBER_CONTROL,

    /**
     * conversion: int
     * length    : D3P_NUM_USER_NUMBER_CONTROL
     * parameters: ignore
     */
    D3P_USER_NUMBER_CONTROL,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    INF_HAS_FRINGE_LABEL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    INF_NUM_FRINGE_LABEL,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    INF_NUM_FRINGE_LABEL_8CHARACTERS,

    /**
     * conversion: int
     * length    : INF_NUM_FRINGE_LABEL
     * parameters: ignore
     */
    INF_FRINGE_LABEL_TYPE_LIST,

    /**
     * conversion: char
     * length    : INF_NUM_FRINGE_LABEL
     * parameters: ignore
     */
    INF_FRINGE_LABEL_LIST,

    /**
     * conversion: bool
     * length    : 1
     * parameters: ignore
     */
    D3P_HAS_D3ISPG,

    /**
     * conversion: char
     * length    : 512
     * parameters: ignore
     */
    D3P_ISPG_FILE_NAME,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3ISPG_VERSION,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ignore
     */
    D3ISPG_NUM_STATES,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3ISPG_NUM_ELEMENTS,

    /**
     * conversion: __int64 or long long
     * length    : D3ISPG_NUM_ELEMENTS times 8
     * parameters: ist
     */
    D3ISPG_ELEMENT_CONNECTIVITY,

    /**
     * conversion: __int64 or long long
     * length    : D3ISPG_NUM_ELEMENTS
     * parameters: ist
     */
    D3ISPG_ELEMENT_USER_ID,

    /**
     * conversion: __int64 or long long
     * length    : D3ISPG_NUM_ELEMENTS
     * parameters: ist
     */
    D3ISPG_ELEMENT_PART_ID,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3ISPG_NUM_NODES,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_COORDINATES,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_CURING,

    /**
     * conversion: __int64 or long long
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_USER_ID,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_PRESSURE,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_TEMPERATURE,

    /**
     * conversion: _D3P_VectorDouble
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_VELOCITY,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES
     * parameters: ist
     */
    D3ISPG_NODE_VISCOSITY,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES times 7
     * parameters: ist
     */
    D3ISPG_NODE_STRAIN_RATE,

    /**
     * conversion: double
     * length    : D3ISPG_NUM_NODES times 7
     * parameters: ist
     */
    D3ISPG_NODE_STRESSES,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3ISPG_NUM_PARTS,

    /**
     * conversion: __int64 or long long
     * length    : D3ISPG_NUM_PARTS
     * parameters: ist
     */
    D3ISPG_PART_USER_ID,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3ISPG_CYCLE,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ist
     */
    D3ISPG_TIME,

    /**
     * conversion: __int64 or long long
     * length    : 1
     * parameters: ignore
     */
    D3ISPG_RUNTIME,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3ISPG_NUM_NODE_DATA,

    /**
     * conversion: _D3DAT_DATA
     * length    : D3ISPG_NUM_NODE_DATA
     * parameters: ignore
     */
    D3ISPG_NODE_DATA,

    /**
     * conversion: int
     * length    : 1
     * parameters: ignore
     */
    D3ISPG_NUM_ELEMENT_DATA,

    /**
     * conversion: _D3DAT_DATA
     * length    : D3ISPG_NUM_ELEMENT_DATA
     * parameters: ignore
     */
    D3ISPG_ELEMENT_DATA,

    /**
     * conversion: IGA_MetaData
     * length    : 1
     * parameters: ignore
     */
    D3IGA_META_DATA,

    /**
     * conversion: IGA_ControlTime
     * length    : 1
     * parameters: ignore
     */
    D3IGA_CONTROL_TIME,

    /**
     * conversion: IGA_Aux
     * length    : 1
     * parameters: ignore
     */
    D3IGA_AUX,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_1D_BREP,

    /**
     * conversion: IGA_1D_BREP
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_1D_BREP,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_1D_NURBS_UVW,

    /**
     * conversion: IGA_1D_NURBS_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_1D_NURBS_UVW,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_1D_NURBS_XYZ,

    /**
     * conversion: IGA_1D_NURBS_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_1D_NURBS_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_BASIS_TRANSFORM_XYZ,

    /**
     * conversion: IGA_nD_BASIS_TRANSFORM_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_BASIS_TRANSFORM_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_2D_BREP,

    /**
     * conversion: IGA_2D_BREP
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_2D_BREP,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_2D_NURBS_UVW,

    /**
     * conversion: IGA_2D_NURBS_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_2D_NURBS_UVW,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_2D_NURBS_XYZ,

    /**
     * conversion: IGA_2D_NURBS_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_2D_NURBS_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_3D_NURBS_XYZ,

    /**
     * conversion: IGA_3D_NURBS_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_3D_NURBS_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_EDGE_UVW,

    /**
     * conversion: IGA_EDGE_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_EDGE_UVW,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_EDGE_XYZ,

    /**
     * conversion: IGA_EDGE_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_EDGE_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_FACE_UVW,

    /**
     * conversion: IGA_FACE_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_FACE_UVW,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_FACE_XYZ,

    /**
     * conversion: IGA_FACE_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_FACE_XYZ,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_POINT_UVW,

    /**
     * conversion: IGA_POINT_UVW
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_POINT_UVW,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_SHELL,

    /**
     * conversion: IGA_SHELL
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_SHELL,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_SOLID,

    /**
     * conversion: IGA_SOLID
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_SOLID,

    /**
     * conversion: long long
     * length    : 1
     * parameters: ignore
     */
    D3IGA_NUM_VOLUME_XYZ,

    /**
     * conversion: IGA_VOLUME_XYZ
     * length    : 1
     * parameters: index (based from 0)
     */
    D3IGA_VOLUME_XYZ,

};

#endif

typedef struct _D3P_Vector_
{
    float v[3];
} _D3P_Vector;

typedef struct D3P_VectorDouble_
{
    double v[3];
} _D3P_VectorDouble;

#ifdef __LSR_DOUBLE_VERSION__
typedef struct _D3P_Tensor_
{
    double t[6];
} _D3P_Tensor;

typedef struct _D3P_Solid_
{
    D3P_INT64 conn[10];
    D3P_INT64 mat;
} _D3P_Solid;

typedef struct _D3P_Tshell_
{
    D3P_INT64 conn[10];
    D3P_INT64 mat;
} _D3P_Tshell;

typedef struct _D3P_Beam_
{
    D3P_INT64 conn[2];
    D3P_INT64 third;
    D3P_INT64 w_D3P_INT64;
    D3P_INT64 h_D3P_INT64;
    D3P_INT64 mat;
} _D3P_Beam;

typedef struct _D3P_Shell_
{
    D3P_INT64 conn[8];
    D3P_INT64 mat;
} _D3P_Shell;

typedef struct _D3P_Sph
{
    D3P_INT64 id;
    D3P_INT64 mat;
} _D3P_Sph;

typedef struct _D3P_Var_
{
    D3P_INT64 type;
    char name[16];
} _D3P_Var;

typedef struct _D3P_Des_
{
    D3P_INT64 id;
    D3P_INT64 mat;
    double radius;
    double mass;
    double inertia;
} _D3P_Des;

typedef struct _D3P_AirbagInfo_
{
    D3P_INT64 bagid;
    D3P_INT64 startn;
    D3P_INT64 npart;
    D3P_INT64 ngas;
    D3P_INT64 nchamber;
} _D3P_AirbagInfo;

typedef struct _D3P_IntArray_
{
    D3P_INT64 num;
    D3P_INT64* data;
} _D3P_IntArray;

typedef struct _D3P_SegmentOfRoadSurf_
{
	D3P_INT64 conn[4];
} _D3P_SegmentOfRoadSurf;

typedef struct _D3P_Control_
{
	char title[80]; /* 0-9  */
	D3P_INT64  runtime;		/* 10   */
	D3P_INT64  date;		/* 11   */
	/* file_type_id
	 * d3plot=1,d3drlf=2,d3thdt=3,D3P_INT64for=4,d3part=5,blstfor=6
	 * d3cpm=7,d3ale=8,d3eigv=11,d3mode=12,d3iter=13,d3ssd=21
	 * d3pcm=22,d3psd=23,d3rms=24,d3ftg=25,d3acs=26 */
	D3P_INT64  machine;		/* 12   version=1000000+svn number */
	D3P_INT64  code;		/* 13   release number */
	double version;		/* 14	doubleing poD3P_INT64 number >= 960.0 */
	D3P_INT64  ndim;		/* 15	number of dimensions + flags */
	D3P_INT64  numnp;		/* 16	number of nodal poD3P_INT64s */
	D3P_INT64  icode;		/* 17	analysis code type */
	D3P_INT64  nglbv;		/* 18	number of global variables */
	D3P_INT64  it;			/* 19	temperature  flag */
	D3P_INT64  iu;			/* 20	geometry flag */
	D3P_INT64  iv;			/* 21   velocity flag */
	D3P_INT64  ia;			/* 22	acceleration flag */
	D3P_INT64  nel8;		/* 23	number of brick elements */
	D3P_INT64  nummat8;		/* 24	number of brick materials */
	D3P_INT64  numds;              /* 25   number of node history blocks */
	D3P_INT64  numst;              /* 26   number of element history blocks */
	D3P_INT64  nv3d;		/* 27	number of brick variables */
	D3P_INT64  nel2;		/* 28	number of beam elements */
	D3P_INT64  nummat2;		/* 29	number of beam materials */
	D3P_INT64  nv1d;		/* 30	number of beam variables */
	D3P_INT64  nel4;		/* 31	number of shell elements */
	D3P_INT64  nummat4;		/* 32	number of shell materials */
	D3P_INT64  nv2d;		/* 33	number of shell variables */
	D3P_INT64  neiph;		/* 34	number of brick history variables */
	D3P_INT64  neips;		/* 35	number of shell history variables */
	D3P_INT64  maxD3P_INT64;		/* 36	max shell LS_D3P_INT64EGER poD3P_INT64s + flags */
	D3P_INT64  nmsph;		/* 37	number of sph nodes */
	D3P_INT64  ngpsph;		/* 38	number of sph materials */
	D3P_INT64  narbs;		/* 39	size of arbitrary numbering array */
	D3P_INT64  nelt;		/* 40	number of thick shell elements */
	D3P_INT64  nummatt;		/* 41	number of thick shell material */
	D3P_INT64  nv3dt;		/* 42	number of thick shell variables */
	D3P_INT64  ioshl[4];		/* 43-46 output reduction flags */
	D3P_INT64  numfluidpart;	/* 47   number of fluid parts */
	D3P_INT64  ncfdv1;             /* 48   flag for Navier-Stokes variables */
	D3P_INT64  ncfdv2;             /* 49   flag for Navier-Stokes variables */
	D3P_INT64  nadapt;             /* 50   number adapted element parents */
	D3P_INT64  nmmat;              /* 51   number of materials */
	D3P_INT64  numfluid;		/* 52   number of fluid materials for mix zones */
	D3P_INT64  inn;                /* 53   control accuracy flags */
	D3P_INT64  npefg;              /* 54   number of efg nodes */
	D3P_INT64  nel48;              /* 55   number of 8 node shell elements */
	D3P_INT64  idtdt;		/* 56   Termal DT/dt flag */
	D3P_INT64  extra;              /* 57   number of extra control words */
	D3P_INT64  nstp;               /* 58   number of sph  history blocks */
	D3P_INT64  iflagd;             /* 59   number of node history blocks + 1000 */
	D3P_INT64  nsth;               /* 60   number of brick history blocks */
	D3P_INT64  nstb;               /* 61   number of beam history blocks */
	D3P_INT64  nsts;               /* 62   number of shell history blocks */
	D3P_INT64  nstt;               /* 63   number of thick shell history blocks */
} _D3P_Control;

typedef struct _D3P_HELM_PART_DATA_
{
    D3P_INT64 pid;     /* part index */
	D3P_INT64 mtype;   /* material model */
	D3P_INT64 ieos;    /* equation of state */
	D3P_INT64 etype;   /* element type: solid=2 */
	D3P_INT64 eform;   /* element formulation */
	D3P_INT64 nelp;    /* number of elements in part */
	D3P_INT64 nmnp;    /* number of nodes in element */
	D3P_INT64 ngpout;  /* number D3P_INT64egration poD3P_INT64s per element */
	D3P_INT64 lengp;   /* number data values per poD3P_INT64 */
	D3P_INT64 nhisv;   /* number of history variables */
	D3P_INT64 istrn;   /* strain output flag */
} _D3P_HELM_PART_DATA;

typedef struct _D3P_RBodyMotion_
{
	double x[3], rx[9], /* current position and rotation matrix */
	      v[3], rv[3], /* velocity: translation and rotation */
	      a[3], ra[3]; /* acceleration: translation and rotation */
} _D3P_RBodyMotion;

typedef struct _D3P_RBodyMotionDouble_
{
	double x[3], rx[9], /* current position and rotation matrix */
	       v[3], rv[3], /* velocity: translation and rotation */
	       a[3], ra[3]; /* acceleration: translation and rotation */
} _D3P_RBodyMotionDouble;

typedef struct _D3P_SolidExtra20_
{
    D3P_INT64 eid;
    D3P_INT64 midn[12];
} _D3P_SolidExtra20;

typedef struct _D3P_SolidExtra27_
{
    D3P_INT64 eid;
    D3P_INT64 midn[19];
} _D3P_SolidExtra27;

typedef struct _D3P_PartTitle_
{
	char pname[80];
	D3P_INT64  pid;
} _D3P_PartTitle;

typedef struct _D3DAT_DATA_ {
	char variable_name[512];
	D3P_INT64 variable_id;
	D3P_INT64 size;
}_D3DAT_DATA;

#else
typedef struct _D3P_Tensor_
{
    float t[6];
} _D3P_Tensor;

typedef struct _D3P_Solid_
{
    int conn[10];
    int mat;
} _D3P_Solid;

typedef struct _D3P_Tshell_
{
    int conn[10];
    int mat;
} _D3P_Tshell;

typedef struct _D3P_Beam_
{
    int conn[2];
    int third;
    int w_int;
    int h_int;
    int mat;
} _D3P_Beam;

typedef struct _D3P_Shell_
{
    int conn[8];
    int mat;
} _D3P_Shell;

typedef struct _D3P_Sph
{
    int id;
    unsigned int mat;
} _D3P_Sph;

typedef struct _D3P_Var_
{
    int type;
    char name[16];
} _D3P_Var;

typedef struct _D3P_Des_
{
    int id;
    int mat;
    float radius;
    float mass;
    float inertia;
} _D3P_Des;

typedef struct _D3P_AirbagInfo_
{
    int bagid;
    int startn;
    int npart;
    int ngas;
    int nchamber;
} _D3P_AirbagInfo;

typedef struct _D3P_IntArray_
{
    int num;
    int* data;
} _D3P_IntArray;

typedef struct _D3P_SegmentOfRoadSurf_
{
	int conn[4];
} _D3P_SegmentOfRoadSurf;

typedef struct _D3P_Control_
{
#ifdef CRAY
	char title[80]; /* 0-9  */
#else
#ifdef __DOUBLE_VERSION__
	char title[80]; /* 0-9  */
#else
	char title[40]; /* 0-9  */
#endif
#endif
	int  runtime;		/* 10   */
	int  date;		/* 11   */
	/* file_type_id
	 * d3plot=1,d3drlf=2,d3thdt=3,intfor=4,d3part=5,blstfor=6
	 * d3cpm=7,d3ale=8,d3eigv=11,d3mode=12,d3iter=13,d3ssd=21
	 * d3pcm=22,d3psd=23,d3rms=24,d3ftg=25,d3acs=26 */
	int  machine;		/* 12   version=1000000+svn number */
	int  code;		/* 13   release number */
	float version;		/* 14	floating point number >= 960.0 */
	int  ndim;		/* 15	number of dimensions + flags */
	int  numnp;		/* 16	number of nodal points */
	int  icode;		/* 17	analysis code type */
	int  nglbv;		/* 18	number of global variables */
	int  it;			/* 19	temperature  flag */
	int  iu;			/* 20	geometry flag */
	int  iv;			/* 21   velocity flag */
	int  ia;			/* 22	acceleration flag */
	int  nel8;		/* 23	number of brick elements */
	int  nummat8;		/* 24	number of brick materials */
	int  numds;              /* 25   number of node history blocks */
	int  numst;              /* 26   number of element history blocks */
	int  nv3d;		/* 27	number of brick variables */
	int  nel2;		/* 28	number of beam elements */
	int  nummat2;		/* 29	number of beam materials */
	int  nv1d;		/* 30	number of beam variables */
	int  nel4;		/* 31	number of shell elements */
	int  nummat4;		/* 32	number of shell materials */
	int  nv2d;		/* 33	number of shell variables */
	int  neiph;		/* 34	number of brick history variables */
	int  neips;		/* 35	number of shell history variables */
	int  maxint;		/* 36	max shell LS_INTEGER points + flags */
	int  nmsph;		/* 37	number of sph nodes */
	int  ngpsph;		/* 38	number of sph materials */
	int  narbs;		/* 39	size of arbitrary numbering array */
	int  nelt;		/* 40	number of thick shell elements */
	int  nummatt;		/* 41	number of thick shell material */
	int  nv3dt;		/* 42	number of thick shell variables */
	int  ioshl[4];		/* 43-46 output reduction flags */
	int  numfluidpart;	/* 47   number of fluid parts */
	int  ncfdv1;             /* 48   flag for Navier-Stokes variables */
	int  ncfdv2;             /* 49   flag for Navier-Stokes variables */
	int  nadapt;             /* 50   number adapted element parents */
	int  nmmat;              /* 51   number of materials */
	int  numfluid;		/* 52   number of fluid materials for mix zones */
	int  inn;                /* 53   control accuracy flags */
	int  npefg;              /* 54   number of efg nodes */
	int  nel48;              /* 55   number of 8 node shell elements */
	int  idtdt;		/* 56   Termal DT/dt flag */
	int  extra;              /* 57   number of extra control words */
	int  nstp;               /* 58   number of sph  history blocks */
	int  iflagd;             /* 59   number of node history blocks + 1000 */
	int  nsth;               /* 60   number of brick history blocks */
	int  nstb;               /* 61   number of beam history blocks */
	int  nsts;               /* 62   number of shell history blocks */
	int  nstt;               /* 63   number of thick shell history blocks */
} _D3P_Control;

typedef struct _D3P_HELM_PART_DATA_
{
    int pid;     /* part index */
	int mtype;   /* material model */
	int ieos;    /* equation of state */
	int etype;   /* element type: solid=2 */
	int eform;   /* element formulation */
	int nelp;    /* number of elements in part */
	int nmnp;    /* number of nodes in element */
	int ngpout;  /* number integration points per element */
	int lengp;   /* number data values per point */
	int nhisv;   /* number of history variables */
	int istrn;   /* strain output flag */
} _D3P_HELM_PART_DATA;

typedef struct _D3P_RBodyMotion_
{
	float x[3], rx[9], /* current position and rotation matrix */
	      v[3], rv[3], /* velocity: translation and rotation */
	      a[3], ra[3]; /* acceleration: translation and rotation */
} _D3P_RBodyMotion;

typedef struct _D3P_RBodyMotionDouble_
{
	double x[3], rx[9], /* current position and rotation matrix */
	       v[3], rv[3], /* velocity: translation and rotation */
	       a[3], ra[3]; /* acceleration: translation and rotation */
} _D3P_RBodyMotionDouble;

typedef struct _D3P_SolidExtra20_
{
    int eid;
    int midn[12];
} _D3P_SolidExtra20;

typedef struct _D3P_SolidExtra27_
{
    int eid;
    int midn[19];
} _D3P_SolidExtra27;

typedef struct _D3P_PartTitle_
{
	char pname[80];
	int  pid;
} _D3P_PartTitle;

typedef struct _D3DAT_DATA_ 
{
	char variable_name[512];
	int variable_id;
	long long size;
}_D3DAT_DATA;
#endif

/**
 * parameter to call D3plotReader::GetData, only specific those member variables you are interesting, otherwise, ignore this
 */
typedef struct _D3P_Parameter_
{
    /**
     * the state number, start from 0 and default is -1
     * the frequency number for frequency domain files.
     */
    int ist;
    /**
     * the integration point, range in [0, MAXINT), and default is -1
     */
    int ipt;
    /**
     * the index of part, start from 0 and default is -1
     */
    int ipart;
    /**
     * the user id of part
     */
    int ipart_user;
    /**
     * the index of rigid wall, start from 0 and default is -1
     */
    int i_rigid_wall;
    /**
     * the index of the des data, start from 0 and default is -1
     */
    int ides;
    /**
     * the index of history variables, start from 0(sequence number)
     */
    int ihv;
    /**
     * the index of the multisolver domain, start from 0 and default is -1
     */
    int index_multisolver;
    /**
     * the index of the multisolver var, start from 0 and default is -1
     */
    int id_var_multisolver;
    /**
     * the index of the user id, default is -1
     */
    int iuser;
    /**
     * for d3atv and d3acc files, it is used to be the value of field point
     */
    int ifieldpoint;
    /**
     * the data option, currently used for frequency domain data, 0-defult, 1-amplitude, 2-phase angle
     */
    int option;
    /**
     *
     * ale fulid group id, start from 1
     */
    int id_fluid_group;
    /**
     * name of output variables, currently used by DES and CPM data, default is empty
     */
     const char* var_name;
    /**
     * part user id set
     */
    _D3P_IntArray ipartset_user;
    /**
	 * the index of road surface, start from 0
	 */
	int isurface;
    /**
	 * the index of road body, start from 0
	 */
	int i_rigid_body;
    /**
	 * the index of minimum entity, start from 0
	 */
	int idmin;
	/**
	 * the index of maximum entity, start from 0
	 */
	int idmax;
    /**
     * the index of variables of interface force file
     */
    int index_var_inf;
} _D3P_Parameter;

#ifdef __cplusplus
extern "C"
{
#endif

CREADERAPI char* D3P_OpenA(const char* filename);
CREADERAPI char* D3P_OpenW(const wchar_t* filename);
CREADERAPI char* D3P_OpenD3hdf5(const char* filename);
CREADERAPI char* D3P_OpenISPGA(const char* filename);
CREADERAPI char* D3P_OpenISPGW(const wchar_t* filename);
CREADERAPI D3P_ReturnType D3P_OpenState(char* handle);
CREADERAPI void D3P_Init(_D3P_Parameter* param);
CREADERAPI void D3P_Reset(_D3P_Parameter* param);
CREADERAPI D3P_ReturnType D3P_SetMessageLevel(char* handle, enum D3P_MessageType type);
CREADERAPI D3P_ReturnType D3P_Read(char* handle, enum D3P_DataType type, char* value, _D3P_Parameter param);
CREADERAPI D3P_ReturnType D3P_Read_Double(char* handle, enum D3P_DataType type, char* value, _D3P_Parameter param);
CREADERAPI void D3P_Close(char* handle);

CREADERAPI const char* Get_LSReaderVersion();

CREADERAPI D3P_ReturnType D3P_WriteHdf5File(char* handle, const char* filename, int compress, int reduction, float reduction_percent);
CREADERAPI void D3P_SetMessageCallback(char* handle, void(*ptr)(const char*, float));

#if defined(UNICODE) || defined(_UNICODE) || defined(__UNICODE) || defined(_UNICODE_) || defined(__UNICODE__)
#define D3P_Open  D3P_OpenW
#define D3P_OpenISPG D3P_OpenISPGW
#else
#define D3P_Open  D3P_OpenA
#define D3P_OpenISPG D3P_OpenISPGA
#endif // !UNICODE

#ifdef __cplusplus
}
#endif

#endif

                    