import os
import sys
import platform

cwd = os.getcwd()
print(cwd)
if platform.system() == 'Windows':
    if sys.version_info[0]==3 and sys.version_info[1]==6:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd,'lib','windows','cp36'
        )))
    elif sys.version_info[0]==3 and sys.version_info[1]==7:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd,'lib','windows','cp37'
        )))
    elif sys.version_info[0]==3 and sys.version_info[1]==8:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd,'lib','windows','cp38'
        )))
    elif sys.version_info[0]==3 and sys.version_info[1]==9:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd,'lib','windows','cp39'
        )))
    elif sys.version_info[0] == 3 and sys.version_info[1] == 10:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd, "lib", "windows", "cp310")))
    elif sys.version_info[0] == 3 and sys.version_info[1] == 11:
        sys.path.insert(0, os.path.normpath(os.path.join(
            cwd, "lib", "windows", "cp311")))
else:
    sys.path.insert(0, os.path.normpath(os.path.join(
        cwd, 'lib', 'linux'
    )))

from lsreader import D3plotReader
from lsreader import DataType as dt
from lsreader import BinoutReader

# d3plotreader
father_path = os.path.abspath(os.path.dirname(cwd)+os.path.sep+".")
data_path = os.path.join(father_path, 'example_data', 'd3plot')
data_path = os.path.normpath(data_path)
dr = D3plotReader(data_path)

shell_stress = dr.get_data(dt.D3P_SHELL_STRESS, ist = 0, ipt = 1)
print(shell_stress[0].x())

shell_eps = dr.get_data(dt.D3P_SHELL_EFFECTIVE_PLASTIC_STRAIN, ist = 0, ipt = 1)
print(shell_eps[0])

thickness = dr.get_data(dt.D3P_SHELL_THICKNESS, ist = 0, ipt = 1)
print(thickness[0])

solid_element = dr.get_data(dt.D3P_NUM_SOLID, ist = 0, ipt = 1)
print(solid_element)

# binoutreader
data_path = os.path.join(father_path, 'example_data', 'binout')
data_path = os.path.normpath(data_path)
br = BinoutReader(data_path)

res = BinoutReader.is_valid(data_path)
print(res)

branches = br.get_branch()
for branch in branches:
    print(branch, end=',')
print('')
br.set_branch('nodout')
ids = br.get_id()
for id in ids:
    print(id, end=',')
print()

br.set_id(1787)
br.set_component('x_acceleration')
x_array = br.get_x_array()
y_array = br.get_y_array()
out_path = os.path.join(cwd, 'nodoutPy.dat')
BinoutReader.write(out_path, x_array, y_array)

# femzipreader
data_path = os.path.join(father_path, 'example_data', 'z805L4plot')
data_path = os.path.normpath(data_path)
dr = D3plotReader(data_path)

shell_element = dr.get_data(dt.D3P_NUM_SHELL, ist = 0, ipt = 1)
print(shell_element)

shell_stress = dr.get_data(dt.D3P_SHELL_STRESS, ist = 0, ipt = 1)
print(shell_stress[0].x())
